/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.zipkin.autoconfigure;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.springframework.util.unit.DataSize;
import zipkin2.reporter.BaseHttpSender;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.HttpEndpointSupplier;

abstract class HttpSender
extends BaseHttpSender<URI, byte[]> {
    private static final DataSize COMPRESSION_THRESHOLD = DataSize.ofKilobytes((long)1L);

    HttpSender(Encoding encoding, HttpEndpointSupplier.Factory endpointSupplierFactory, String endpoint) {
        super(encoding, endpointSupplierFactory, endpoint);
    }

    protected URI newEndpoint(String endpoint) {
        return URI.create(endpoint);
    }

    protected byte[] newBody(List<byte[]> list) {
        return this.encoding.encode(list);
    }

    protected void postSpans(URI endpoint, byte[] body) throws IOException {
        Map<String, String> headers = this.getDefaultHeaders();
        if (this.needsCompression(body)) {
            body = this.compress(body);
            headers.put("Content-Encoding", "gzip");
        }
        this.postSpans(endpoint, headers, body);
    }

    abstract void postSpans(URI var1, Map<String, String> var2, byte[] var3) throws IOException;

    Map<String, String> getDefaultHeaders() {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("b3", "0");
        headers.put("Content-Type", this.encoding.mediaType());
        return headers;
    }

    private boolean needsCompression(byte[] body) {
        return (long)body.length > COMPRESSION_THRESHOLD.toBytes();
    }

    private byte[] compress(byte[] input) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(result);){
            gzip.write(input);
        }
        return result.toByteArray();
    }
}

