/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webtestclient.autoconfigure;

import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.codec.CodecCustomizer;
import org.springframework.boot.http.codec.autoconfigure.CodecsAutoConfiguration;
import org.springframework.boot.test.http.server.LocalTestWebServer;
import org.springframework.boot.webtestclient.autoconfigure.SpringBootWebTestClientBuilderCustomizer;
import org.springframework.boot.webtestclient.autoconfigure.WebTestClientBuilderCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.test.web.reactive.server.MockServerConfigurer;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.client.MockMvcWebTestClient;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration(after={CodecsAutoConfiguration.class})
@ConditionalOnClass(value={CodecCustomizer.class, WebClient.class, WebTestClient.class})
@EnableConfigurationProperties
public final class WebTestClientAutoConfiguration {
    private static final String WEB_APPLICATION_CONTEXT_CLASS = "org.springframework.web.context.WebApplicationContext";

    @Bean
    @ConfigurationProperties(value="spring.test.webtestclient")
    SpringBootWebTestClientBuilderCustomizer springBootWebTestClientBuilderCustomizer(ObjectProvider<CodecCustomizer> codecCustomizers) {
        return new SpringBootWebTestClientBuilderCustomizer(codecCustomizers.orderedStream().toList());
    }

    @Bean
    @ConditionalOnMissingBean
    WebTestClient webTestClient(ApplicationContext applicationContext, List<WebTestClientBuilderCustomizer> customizers, List<MockServerConfigurer> configurers) {
        WebTestClient.Builder builder = this.getBuilder(applicationContext, configurers);
        customizers.forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    private WebTestClient.Builder getBuilder(ApplicationContext applicationContext, List<MockServerConfigurer> configurers) {
        LocalTestWebServer localTestWebServer = LocalTestWebServer.get((ApplicationContext)applicationContext);
        if (localTestWebServer != null) {
            return WebTestClient.bindToServer().uriBuilderFactory(localTestWebServer.uriBuilderFactory());
        }
        if (applicationContext.containsBean("webHandler")) {
            WebTestClient.MockServerSpec spec = WebTestClient.bindToApplicationContext((ApplicationContext)applicationContext);
            configurers.forEach(arg_0 -> ((WebTestClient.MockServerSpec)spec).apply(arg_0));
            return spec.configureClient();
        }
        if (ClassUtils.isPresent((String)WEB_APPLICATION_CONTEXT_CLASS, (ClassLoader)applicationContext.getClassLoader())) {
            MockMvc mockMvc = (MockMvc)applicationContext.getBeanProvider(MockMvc.class).getIfUnique();
            if (mockMvc != null) {
                return MockMvcWebTestClient.bindTo((MockMvc)mockMvc);
            }
            if (applicationContext instanceof WebApplicationContext) {
                WebApplicationContext webApplicationContext = (WebApplicationContext)applicationContext;
                return MockMvcWebTestClient.bindToApplicationContext((WebApplicationContext)webApplicationContext).configureClient();
            }
        }
        throw new IllegalStateException("Mock WebTestClient support requires a WebHandler (named 'webHandler') bean or a WebApplicationContext and neither was present");
    }
}

