/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.websocket.autoconfigure.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.LazyInitializationExcludeFilter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.JacksonJsonMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.simp.config.AbstractMessageBrokerConfiguration;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.socket.config.annotation.DelegatingWebSocketMessageBrokerConfiguration;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration(afterName={"org.springframework.boot.jackson.autoconfigure.JacksonAutoConfiguration", "org.springframework.boot.jackson2.autoconfigure.Jackson2AutoConfiguration"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={WebSocketMessageBrokerConfigurer.class})
public final class WebSocketMessagingAutoConfiguration {

    static class NoJacksonOrJackson2Preferred
    extends AnyNestedCondition {
        NoJacksonOrJackson2Preferred() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(name={"spring.websocket.messaging.preferred-json-mapper"}, havingValue="jackson2")
        static class Jackson2Preferred {
            Jackson2Preferred() {
            }
        }

        @ConditionalOnMissingClass(value={"tools.jackson.databind.json.JsonMapper"})
        static class NoJackson {
            NoJackson() {
            }
        }
    }

    @Order(value=1)
    @Configuration(proxyBeanMethods=false)
    @Deprecated(since="4.0.0", forRemoval=true)
    @Conditional(value={NoJacksonOrJackson2Preferred.class})
    @ConditionalOnClass(value={ObjectMapper.class})
    static class Jackson2WebSocketMessageConverterConfiguration
    implements WebSocketMessageBrokerConfigurer {
        private final ObjectMapper objectMapper;

        Jackson2WebSocketMessageConverterConfiguration(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
            MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter(this.objectMapper);
            DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
            resolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
            converter.setContentTypeResolver((ContentTypeResolver)resolver);
            messageConverters.add((MessageConverter)converter);
            return false;
        }
    }

    @Order(value=1)
    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"spring.websocket.messaging.preferred-json-mapper"}, havingValue="jackson", matchIfMissing=true)
    @ConditionalOnClass(value={JsonMapper.class})
    static class JacksonWebSocketMessageConverterConfiguration
    implements WebSocketMessageBrokerConfigurer {
        private final JsonMapper jsonMapper;

        JacksonWebSocketMessageConverterConfiguration(JsonMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
        }

        public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
            JacksonJsonMessageConverter converter = new JacksonJsonMessageConverter(this.jsonMapper);
            DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
            resolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
            converter.setContentTypeResolver((ContentTypeResolver)resolver);
            messageConverters.add((MessageConverter)converter);
            return false;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={DelegatingWebSocketMessageBrokerConfiguration.class, JsonMapper.class})
    @ConditionalOnClass(value={JsonMapper.class, AbstractMessageBrokerConfiguration.class})
    @Order(value=0)
    static class SpringBootWebSocketMessageBrokerConfiguration
    implements WebSocketMessageBrokerConfigurer {
        private final JsonMapper jsonMapper;
        private final @Nullable AsyncTaskExecutor executor;

        SpringBootWebSocketMessageBrokerConfiguration(JsonMapper jsonMapper, Map<String, AsyncTaskExecutor> taskExecutors) {
            this.jsonMapper = jsonMapper;
            this.executor = SpringBootWebSocketMessageBrokerConfiguration.determineAsyncTaskExecutor(taskExecutors);
        }

        private static @Nullable AsyncTaskExecutor determineAsyncTaskExecutor(Map<String, AsyncTaskExecutor> taskExecutors) {
            if (taskExecutors.size() == 1) {
                return taskExecutors.values().iterator().next();
            }
            return taskExecutors.get("applicationTaskExecutor");
        }

        public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
            messageConverters.add((MessageConverter)new StringMessageConverter());
            messageConverters.add((MessageConverter)new ByteArrayMessageConverter());
            JacksonJsonMessageConverter converter = new JacksonJsonMessageConverter(this.jsonMapper);
            DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
            resolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
            converter.setContentTypeResolver((ContentTypeResolver)resolver);
            messageConverters.add((MessageConverter)converter);
            return false;
        }

        public void configureClientInboundChannel(ChannelRegistration registration) {
            if (this.executor != null) {
                registration.executor((Executor)this.executor);
            }
        }

        public void configureClientOutboundChannel(ChannelRegistration registration) {
            if (this.executor != null) {
                registration.executor((Executor)this.executor);
            }
        }

        @Bean
        static LazyInitializationExcludeFilter eagerStompWebSocketHandlerMapping() {
            return (name, definition, type) -> name.equals("stompWebSocketHandlerMapping");
        }
    }
}

