/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc;

import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.boot.WebApplicationType;
import org.springframework.core.annotation.Order;
import org.springframework.util.ClassUtils;

@Order(value=10)
class WebMvcWebApplicationTypeDeducer
implements WebApplicationType.Deducer {
    private static final String[] INDICATOR_CLASSES = new String[]{"jakarta.servlet.Servlet", "org.springframework.web.servlet.DispatcherServlet", "org.springframework.web.context.ConfigurableWebApplicationContext"};

    WebMvcWebApplicationTypeDeducer() {
    }

    public @Nullable WebApplicationType deduceWebApplicationType() {
        for (String indicatorClass : INDICATOR_CLASSES) {
            if (ClassUtils.isPresent((String)indicatorClass, null)) continue;
            return null;
        }
        return WebApplicationType.SERVLET;
    }

    static class WebMvcWebApplicationTypeDeducerRuntimeHints
    implements RuntimeHintsRegistrar {
        WebMvcWebApplicationTypeDeducerRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            for (String servletIndicatorClass : INDICATOR_CLASSES) {
                this.registerTypeIfPresent(servletIndicatorClass, classLoader, hints);
            }
        }

        private void registerTypeIfPresent(String typeName, @Nullable ClassLoader classLoader, RuntimeHints hints) {
            if (ClassUtils.isPresent((String)typeName, (ClassLoader)classLoader)) {
                hints.reflection().registerType(TypeReference.of((String)typeName), new MemberCategory[0]);
            }
        }
    }
}

