/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.autoconfigure.actuate.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.CorsEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.EndpointAccessResolver;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.jackson.EndpointJackson2ObjectMapper;
import org.springframework.boot.actuate.endpoint.jackson.EndpointJsonMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.ServletEndpointRegistrar;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.health.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.health.actuate.endpoint.HealthEndpointGroups;
import org.springframework.boot.webmvc.actuate.endpoint.web.AdditionalHealthEndpointPathsWebMvcHandlerMapping;
import org.springframework.boot.webmvc.actuate.endpoint.web.ControllerEndpointHandlerMapping;
import org.springframework.boot.webmvc.actuate.endpoint.web.WebMvcEndpointHandlerMapping;
import org.springframework.boot.webmvc.autoconfigure.DispatcherServletPath;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import tools.jackson.databind.json.JsonMapper;

@ManagementContextConfiguration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnBean(value={DispatcherServlet.class, WebEndpointsSupplier.class})
@EnableConfigurationProperties(value={CorsEndpointProperties.class})
public class WebMvcEndpointManagementContextConfiguration {
    private static final List<MediaType> MEDIA_TYPES = Collections.unmodifiableList(Arrays.asList(MediaType.APPLICATION_JSON, new MediaType("application", "*+json")));

    @Bean
    @ConditionalOnMissingBean
    WebMvcEndpointHandlerMapping webEndpointServletHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, ServletEndpointsSupplier servletEndpointsSupplier, ControllerEndpointsSupplier controllerEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties, Environment environment) {
        ArrayList allEndpoints = new ArrayList();
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        allEndpoints.addAll(webEndpoints);
        allEndpoints.addAll(servletEndpointsSupplier.getEndpoints());
        allEndpoints.addAll(controllerEndpointsSupplier.getEndpoints());
        String basePath = webEndpointProperties.getBasePath();
        EndpointMapping endpointMapping = new EndpointMapping(basePath);
        boolean shouldRegisterLinksMapping = this.shouldRegisterLinksMapping(webEndpointProperties, environment, basePath);
        return new WebMvcEndpointHandlerMapping(endpointMapping, webEndpoints, endpointMediaTypes, corsProperties.toCorsConfiguration(), new EndpointLinksResolver(allEndpoints, basePath), shouldRegisterLinksMapping);
    }

    private boolean shouldRegisterLinksMapping(WebEndpointProperties webEndpointProperties, Environment environment, String basePath) {
        return webEndpointProperties.getDiscovery().isEnabled() && (StringUtils.hasText((String)basePath) || ManagementPortType.get((Environment)environment).equals((Object)ManagementPortType.DIFFERENT));
    }

    @Bean
    @ConditionalOnMissingBean
    @Deprecated(since="3.3.5", forRemoval=true)
    ControllerEndpointHandlerMapping controllerEndpointHandlerMapping(ControllerEndpointsSupplier controllerEndpointsSupplier, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties, EndpointAccessResolver endpointAccessResolver) {
        EndpointMapping endpointMapping = new EndpointMapping(webEndpointProperties.getBasePath());
        return new ControllerEndpointHandlerMapping(endpointMapping, controllerEndpointsSupplier.getEndpoints(), corsProperties.toCorsConfiguration(), endpointAccessResolver);
    }

    @Bean
    ServletEndpointRegistrar servletEndpointRegistrar(WebEndpointProperties properties, ServletEndpointsSupplier servletEndpointsSupplier, DispatcherServletPath dispatcherServletPath, EndpointAccessResolver endpointAccessResolver) {
        return new ServletEndpointRegistrar(dispatcherServletPath.getRelativePath(properties.getBasePath()), servletEndpointsSupplier.getEndpoints(), endpointAccessResolver);
    }

    @Bean
    @ConditionalOnBean(value={EndpointJsonMapper.class})
    @Role(value=2)
    static EndpointJsonMapperWebMvcConfigurer endpointJsonMapperWebMvcConfigurer(EndpointJsonMapper endpointJsonMapper) {
        return new EndpointJsonMapperWebMvcConfigurer(endpointJsonMapper);
    }

    @Bean
    @ConditionalOnBean(value={EndpointJackson2ObjectMapper.class})
    @Role(value=2)
    static EndpointJackson2ObjectMapperWebMvcConfigurer endpointJackson2ObjectMapperWebMvcConfigurer(EndpointJackson2ObjectMapper endpointJsonMapper) {
        return new EndpointJackson2ObjectMapperWebMvcConfigurer(endpointJsonMapper);
    }

    static class EndpointJsonMapperWebMvcConfigurer
    implements WebMvcConfigurer {
        private final EndpointJsonMapper mapper;

        EndpointJsonMapperWebMvcConfigurer(EndpointJsonMapper mapper) {
            this.mapper = mapper;
        }

        public void configureMessageConverters(HttpMessageConverters.ServerBuilder builder) {
            builder.configureMessageConverters(converter -> {
                if (converter instanceof JacksonJsonHttpMessageConverter) {
                    JacksonJsonHttpMessageConverter jacksonConverter = (JacksonJsonHttpMessageConverter)converter;
                    this.configure(jacksonConverter);
                }
            });
        }

        private void configure(JacksonJsonHttpMessageConverter converter) {
            converter.registerMappersForType(OperationResponseBody.class, associations -> {
                JsonMapper jsonMapper = this.mapper.get();
                MEDIA_TYPES.forEach(mimeType -> associations.put(mimeType, jsonMapper));
            });
        }
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    static class EndpointJackson2ObjectMapperWebMvcConfigurer
    implements WebMvcConfigurer {
        private final EndpointJackson2ObjectMapper mapper;

        EndpointJackson2ObjectMapperWebMvcConfigurer(EndpointJackson2ObjectMapper mapper) {
            this.mapper = mapper;
        }

        public void configureMessageConverters(HttpMessageConverters.ServerBuilder builder) {
            builder.configureMessageConverters(converter -> {
                if (converter instanceof MappingJackson2HttpMessageConverter) {
                    MappingJackson2HttpMessageConverter jacksonConverter = (MappingJackson2HttpMessageConverter)converter;
                    this.configure(jacksonConverter);
                }
            });
        }

        private void configure(MappingJackson2HttpMessageConverter converter) {
            converter.registerObjectMappersForType(OperationResponseBody.class, associations -> {
                ObjectMapper jsonMapper = this.mapper.get();
                MEDIA_TYPES.forEach(mimeType -> associations.put(mimeType, jsonMapper));
            });
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HealthEndpoint.class})
    static class HealthConfiguration {
        HealthConfiguration() {
        }

        @Bean
        @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
        @ConditionalOnBean(value={HealthEndpoint.class})
        @ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class, exposure={EndpointExposure.WEB})
        AdditionalHealthEndpointPathsWebMvcHandlerMapping managementHealthEndpointWebMvcHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, HealthEndpointGroups groups) {
            Collection webEndpoints = webEndpointsSupplier.getEndpoints();
            ExposableWebEndpoint healthEndpoint = webEndpoints.stream().filter(this::isHealthEndpoint).findFirst().orElse(null);
            return new AdditionalHealthEndpointPathsWebMvcHandlerMapping(healthEndpoint, groups.getAllWithAdditionalPath(WebServerNamespace.MANAGEMENT));
        }

        private boolean isHealthEndpoint(ExposableWebEndpoint endpoint) {
            return endpoint.getEndpointId().equals((Object)HealthEndpoint.ID);
        }
    }
}

