/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.actuate.endpoint.web;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.WebOperationRequestPredicate;
import org.springframework.boot.health.actuate.endpoint.AdditionalHealthEndpointPath;
import org.springframework.boot.health.actuate.endpoint.HealthEndpointGroup;
import org.springframework.boot.webmvc.actuate.endpoint.web.AbstractWebMvcEndpointHandlerMapping;

public class AdditionalHealthEndpointPathsWebMvcHandlerMapping
extends AbstractWebMvcEndpointHandlerMapping {
    private final @Nullable ExposableWebEndpoint healthEndpoint;
    private final Set<HealthEndpointGroup> groups;

    public AdditionalHealthEndpointPathsWebMvcHandlerMapping(@Nullable ExposableWebEndpoint healthEndpoint, Set<HealthEndpointGroup> groups) {
        super(new EndpointMapping(""), AdditionalHealthEndpointPathsWebMvcHandlerMapping.asList(healthEndpoint), new EndpointMediaTypes(new String[0]), false);
        this.healthEndpoint = healthEndpoint;
        this.groups = groups;
    }

    private static Collection<ExposableWebEndpoint> asList(@Nullable ExposableWebEndpoint healthEndpoint) {
        return healthEndpoint != null ? Collections.singletonList(healthEndpoint) : Collections.emptyList();
    }

    @Override
    protected void initHandlerMethods() {
        if (this.healthEndpoint == null) {
            return;
        }
        for (WebOperation operation : this.healthEndpoint.getOperations()) {
            WebOperationRequestPredicate predicate = operation.getRequestPredicate();
            String matchAllRemainingPathSegmentsVariable = predicate.getMatchAllRemainingPathSegmentsVariable();
            if (matchAllRemainingPathSegmentsVariable == null) continue;
            for (HealthEndpointGroup group : this.groups) {
                AdditionalHealthEndpointPath additionalPath = group.getAdditionalPath();
                if (additionalPath == null) continue;
                this.registerMapping(this.healthEndpoint, predicate, operation, additionalPath.getValue());
            }
        }
    }

    @Override
    protected AbstractWebMvcEndpointHandlerMapping.LinksHandler getLinksHandler() {
        return (request, response) -> null;
    }
}

