/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.autoconfigure.actuate.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.CorsEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.EndpointAccessResolver;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.jackson.EndpointJackson2ObjectMapper;
import org.springframework.boot.actuate.endpoint.jackson.EndpointJsonMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.health.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.health.actuate.endpoint.HealthEndpointGroups;
import org.springframework.boot.webflux.actuate.endpoint.web.AdditionalHealthEndpointPathsWebFluxHandlerMapping;
import org.springframework.boot.webflux.actuate.endpoint.web.ControllerEndpointHandlerMapping;
import org.springframework.boot.webflux.actuate.endpoint.web.WebFluxEndpointHandlerMapping;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.codec.Encoder;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.json.JacksonJsonEncoder;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.StringUtils;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.web.reactive.DispatcherHandler;
import tools.jackson.databind.json.JsonMapper;

@ManagementContextConfiguration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={DispatcherHandler.class, HttpHandler.class})
@ConditionalOnBean(value={WebEndpointsSupplier.class})
@EnableConfigurationProperties(value={CorsEndpointProperties.class})
public class WebFluxEndpointManagementContextConfiguration {
    private static final List<MediaType> MEDIA_TYPES = Collections.unmodifiableList(Arrays.asList(MediaType.APPLICATION_JSON, new MediaType("application", "*+json")));

    @Bean
    @ConditionalOnMissingBean
    public WebFluxEndpointHandlerMapping webEndpointReactiveHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, ControllerEndpointsSupplier controllerEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties, Environment environment) {
        String basePath = webEndpointProperties.getBasePath();
        EndpointMapping endpointMapping = new EndpointMapping(basePath);
        Collection endpoints = webEndpointsSupplier.getEndpoints();
        ArrayList allEndpoints = new ArrayList();
        allEndpoints.addAll(endpoints);
        allEndpoints.addAll(controllerEndpointsSupplier.getEndpoints());
        return new WebFluxEndpointHandlerMapping(endpointMapping, endpoints, endpointMediaTypes, corsProperties.toCorsConfiguration(), new EndpointLinksResolver(allEndpoints, basePath), this.shouldRegisterLinksMapping(webEndpointProperties, environment, basePath));
    }

    private boolean shouldRegisterLinksMapping(WebEndpointProperties properties, Environment environment, String basePath) {
        return properties.getDiscovery().isEnabled() && (StringUtils.hasText((String)basePath) || ManagementPortType.get((Environment)environment) == ManagementPortType.DIFFERENT);
    }

    @Bean
    @ConditionalOnMissingBean
    @Deprecated(since="3.3.5", forRemoval=true)
    public ControllerEndpointHandlerMapping controllerEndpointHandlerMapping(ControllerEndpointsSupplier controllerEndpointsSupplier, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties, EndpointAccessResolver endpointAccessResolver) {
        EndpointMapping endpointMapping = new EndpointMapping(webEndpointProperties.getBasePath());
        return new ControllerEndpointHandlerMapping(endpointMapping, controllerEndpointsSupplier.getEndpoints(), corsProperties.toCorsConfiguration(), endpointAccessResolver);
    }

    @Bean
    @ConditionalOnBean(value={EndpointJsonMapper.class})
    @Role(value=2)
    static ServerCodecConfigurerEndpointJsonMapperBeanPostProcessor serverCodecConfigurerEndpointJsonMapperBeanPostProcessor(ObjectProvider<EndpointJsonMapper> endpointJsonMapper) {
        return new ServerCodecConfigurerEndpointJsonMapperBeanPostProcessor((Supplier<EndpointJsonMapper>)SingletonSupplier.of(() -> endpointJsonMapper.getObject()));
    }

    @Bean
    @ConditionalOnBean(value={EndpointJackson2ObjectMapper.class})
    @Role(value=2)
    static ServerCodecConfigurerEndpointJackson2JsonMapperBeanPostProcessor serverCodecConfigurerEndpointJackson2JsonMapperBeanPostProcessor(ObjectProvider<EndpointJackson2ObjectMapper> endpointJsonMapper) {
        return new ServerCodecConfigurerEndpointJackson2JsonMapperBeanPostProcessor((Supplier<EndpointJackson2ObjectMapper>)SingletonSupplier.of(() -> endpointJsonMapper.getObject()));
    }

    static class ServerCodecConfigurerEndpointJsonMapperBeanPostProcessor
    implements BeanPostProcessor {
        private final Supplier<EndpointJsonMapper> mapper;

        ServerCodecConfigurerEndpointJsonMapperBeanPostProcessor(Supplier<EndpointJsonMapper> mapper) {
            this.mapper = mapper;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof ServerCodecConfigurer) {
                ServerCodecConfigurer serverCodecConfigurer = (ServerCodecConfigurer)bean;
                this.process(serverCodecConfigurer);
            }
            return bean;
        }

        private void process(ServerCodecConfigurer configurer) {
            for (HttpMessageWriter writer : configurer.getWriters()) {
                if (!(writer instanceof EncoderHttpMessageWriter)) continue;
                EncoderHttpMessageWriter encoderHttpMessageWriter = (EncoderHttpMessageWriter)writer;
                this.process(encoderHttpMessageWriter.getEncoder());
            }
        }

        private void process(Encoder<?> encoder) {
            if (encoder instanceof JacksonJsonEncoder) {
                JacksonJsonEncoder jacksonEncoder = (JacksonJsonEncoder)encoder;
                jacksonEncoder.registerMappersForType(OperationResponseBody.class, associations -> {
                    JsonMapper mapper = this.mapper.get().get();
                    MEDIA_TYPES.forEach(mimeType -> associations.put(mimeType, mapper));
                });
            }
        }
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    static class ServerCodecConfigurerEndpointJackson2JsonMapperBeanPostProcessor
    implements BeanPostProcessor {
        private final Supplier<EndpointJackson2ObjectMapper> mapper;

        ServerCodecConfigurerEndpointJackson2JsonMapperBeanPostProcessor(Supplier<EndpointJackson2ObjectMapper> mapper) {
            this.mapper = mapper;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof ServerCodecConfigurer) {
                ServerCodecConfigurer serverCodecConfigurer = (ServerCodecConfigurer)bean;
                this.process(serverCodecConfigurer);
            }
            return bean;
        }

        private void process(ServerCodecConfigurer configurer) {
            for (HttpMessageWriter writer : configurer.getWriters()) {
                if (!(writer instanceof EncoderHttpMessageWriter)) continue;
                EncoderHttpMessageWriter encoderHttpMessageWriter = (EncoderHttpMessageWriter)writer;
                this.process(encoderHttpMessageWriter.getEncoder());
            }
        }

        private void process(Encoder<?> encoder) {
            if (encoder instanceof Jackson2JsonEncoder) {
                Jackson2JsonEncoder jacksonEncoder = (Jackson2JsonEncoder)encoder;
                jacksonEncoder.registerObjectMappersForType(OperationResponseBody.class, associations -> {
                    ObjectMapper mapper = this.mapper.get().get();
                    MEDIA_TYPES.forEach(mimeType -> associations.put(mimeType, mapper));
                });
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HealthEndpoint.class})
    static class HealthConfiguration {
        HealthConfiguration() {
        }

        @Bean
        @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
        @ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class, exposure={EndpointExposure.WEB})
        @ConditionalOnBean(value={HealthEndpoint.class})
        AdditionalHealthEndpointPathsWebFluxHandlerMapping managementHealthEndpointWebFluxHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, HealthEndpointGroups groups) {
            Collection webEndpoints = webEndpointsSupplier.getEndpoints();
            ExposableWebEndpoint healthEndpoint = webEndpoints.stream().filter(endpoint -> endpoint.getEndpointId().equals((Object)HealthEndpoint.ID)).findFirst().orElse(null);
            return new AdditionalHealthEndpointPathsWebFluxHandlerMapping(new EndpointMapping(""), healthEndpoint, groups.getAllWithAdditionalPath(WebServerNamespace.MANAGEMENT));
        }
    }
}

