/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.servlet;

import java.io.File;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.boot.web.server.Cookie;
import org.springframework.boot.web.server.servlet.SessionStoreDirectory;

public class Session {
    @DurationUnit(value=ChronoUnit.SECONDS)
    private @Nullable Duration timeout = Duration.ofMinutes(30L);
    private @Nullable Set<SessionTrackingMode> trackingModes;
    private boolean persistent;
    private @Nullable File storeDir;
    @NestedConfigurationProperty
    private final Cookie cookie = new Cookie();
    private final SessionStoreDirectory sessionStoreDirectory = new SessionStoreDirectory();

    public @Nullable Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(@Nullable Duration timeout) {
        this.timeout = timeout;
    }

    public @Nullable Set<SessionTrackingMode> getTrackingModes() {
        return this.trackingModes;
    }

    public void setTrackingModes(@Nullable Set<SessionTrackingMode> trackingModes) {
        this.trackingModes = trackingModes;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public @Nullable File getStoreDir() {
        return this.storeDir;
    }

    public void setStoreDir(@Nullable File storeDir) {
        this.sessionStoreDirectory.setDirectory(storeDir);
        this.storeDir = storeDir;
    }

    public Cookie getCookie() {
        return this.cookie;
    }

    public SessionStoreDirectory getSessionStoreDirectory() {
        return this.sessionStoreDirectory;
    }

    public static enum SessionTrackingMode {
        COOKIE,
        URL,
        SSL;

    }
}

