/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.test.client.reactive;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.test.client.reactive.WebTestClientContextCustomizer;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.util.ClassUtils;

class WebTestClientContextCustomizerFactory
implements ContextCustomizerFactory {
    private static final boolean webClientPresent;

    WebTestClientContextCustomizerFactory() {
    }

    public @Nullable ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        SpringBootTest springBootTest = (SpringBootTest)TestContextAnnotationUtils.findMergedAnnotation(testClass, SpringBootTest.class);
        return springBootTest != null && webClientPresent ? new WebTestClientContextCustomizer() : null;
    }

    static {
        ClassLoader loader = WebTestClientContextCustomizerFactory.class.getClassLoader();
        webClientPresent = ClassUtils.isPresent((String)"org.springframework.web.reactive.function.client.WebClient", (ClassLoader)loader);
    }
}

