/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.undertow.reactive;

import io.undertow.Undertow;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.undertow.ConfigurableUndertowWebServerFactory;
import org.springframework.boot.undertow.HttpHandlerFactory;
import org.springframework.boot.undertow.UndertowWebServer;
import org.springframework.boot.undertow.UndertowWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.reactive.ConfigurableReactiveWebServerFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.UndertowHttpHandlerAdapter;

public class UndertowReactiveWebServerFactory
extends UndertowWebServerFactory
implements ConfigurableUndertowWebServerFactory,
ConfigurableReactiveWebServerFactory {
    public UndertowReactiveWebServerFactory() {
    }

    public UndertowReactiveWebServerFactory(int port) {
        super(port);
    }

    public WebServer getWebServer(HttpHandler httpHandler) {
        UndertowReactiveWebServerFactory undertowReactiveWebServerFactory = this;
        Supplier<SslBundle> supplier = () -> undertowReactiveWebServerFactory.getSslBundle();
        undertowReactiveWebServerFactory = this;
        Undertow.Builder builder = this.createBuilder(this, supplier, () -> undertowReactiveWebServerFactory.getServerNameSslBundles());
        List<HttpHandlerFactory> httpHandlerFactories = this.createHttpHandlerFactories(this, next -> new UndertowHttpHandlerAdapter(httpHandler));
        return new UndertowWebServer(builder, httpHandlerFactories, this.getPort() >= 0);
    }
}

