/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.transaction.autoconfigure;

import org.springframework.boot.LazyInitializationExcludeFilter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.ReactiveTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.annotation.AbstractTransactionManagementConfiguration;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.aspectj.AbstractTransactionAspect;
import org.springframework.transaction.reactive.TransactionalOperator;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;

@AutoConfiguration
@ConditionalOnClass(value={PlatformTransactionManager.class})
public final class TransactionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnSingleCandidate(value=ReactiveTransactionManager.class)
    TransactionalOperator transactionalOperator(ReactiveTransactionManager transactionManager) {
        return TransactionalOperator.create((ReactiveTransactionManager)transactionManager);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={AbstractTransactionAspect.class})
    static class AspectJTransactionManagementConfiguration {
        AspectJTransactionManagementConfiguration() {
        }

        @Bean
        static LazyInitializationExcludeFilter eagerTransactionAspect() {
            return LazyInitializationExcludeFilter.forBeanTypes((Class[])new Class[]{AbstractTransactionAspect.class});
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={TransactionManager.class})
    @ConditionalOnMissingBean(value={AbstractTransactionManagementConfiguration.class})
    static class EnableTransactionManagementConfiguration {
        EnableTransactionManagementConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @EnableTransactionManagement(proxyTargetClass=true)
        @ConditionalOnBooleanProperty(name={"spring.aop.proxy-target-class"}, matchIfMissing=true)
        static class CglibAutoProxyConfiguration {
            CglibAutoProxyConfiguration() {
            }
        }

        @Configuration(proxyBeanMethods=false)
        @EnableTransactionManagement(proxyTargetClass=false)
        @ConditionalOnBooleanProperty(name={"spring.aop.proxy-target-class"}, havingValue=false)
        static class JdkDynamicAutoProxyConfiguration {
            JdkDynamicAutoProxyConfiguration() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnSingleCandidate(value=PlatformTransactionManager.class)
    static class TransactionTemplateConfiguration {
        TransactionTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={TransactionOperations.class})
        TransactionTemplate transactionTemplate(PlatformTransactionManager transactionManager) {
            return new TransactionTemplate(transactionManager);
        }
    }
}

