/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tomcat;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.util.modeler.Registry;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.tomcat.CompressionConnectorCustomizer;
import org.springframework.boot.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.tomcat.SslConnectorCustomizer;
import org.springframework.boot.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.tomcat.TomcatContextCustomizer;
import org.springframework.boot.tomcat.TomcatProtocolHandlerCustomizer;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.boot.web.server.AbstractConfigurableWebServerFactory;
import org.springframework.boot.web.server.Ssl;
import org.springframework.core.NativeDetector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TomcatWebServerFactory
extends AbstractConfigurableWebServerFactory
implements ConfigurableTomcatWebServerFactory {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String DEFAULT_PROTOCOL = "org.apache.coyote.http11.Http11NioProtocol";
    private final Log logger = LogFactory.getLog(this.getClass());
    private @Nullable File baseDirectory;
    private int backgroundProcessorDelay;
    private List<Valve> engineValves = new ArrayList<Valve>();
    private List<Valve> contextValves = new ArrayList<Valve>();
    private List<LifecycleListener> contextLifecycleListeners = new ArrayList<LifecycleListener>();
    private Set<TomcatContextCustomizer> contextCustomizers = new LinkedHashSet<TomcatContextCustomizer>();
    private Set<TomcatConnectorCustomizer> connectorCustomizers = new LinkedHashSet<TomcatConnectorCustomizer>();
    private Set<TomcatProtocolHandlerCustomizer<?>> protocolHandlerCustomizers = new LinkedHashSet();
    private List<Connector> additionalConnectors = new ArrayList<Connector>();
    private Charset uriEncoding = DEFAULT_CHARSET;
    private String protocol = "org.apache.coyote.http11.Http11NioProtocol";
    private boolean disableMBeanRegistry = true;
    private boolean useApr;

    protected TomcatWebServerFactory() {
    }

    protected TomcatWebServerFactory(int port) {
        super(port);
    }

    private List<LifecycleListener> getDefaultServerLifecycleListeners() {
        ArrayList<LifecycleListener> lifecycleListeners = new ArrayList<LifecycleListener>();
        if (this.useApr && !NativeDetector.inNativeImage()) {
            lifecycleListeners.add((LifecycleListener)new AprLifecycleListener());
        }
        return lifecycleListeners;
    }

    @Override
    public void setBaseDirectory(@Nullable File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public @Nullable File getBaseDirectory() {
        return this.baseDirectory;
    }

    public Collection<Valve> getEngineValves() {
        return this.engineValves;
    }

    public void setEngineValves(Collection<? extends Valve> engineValves) {
        Assert.notNull(engineValves, (String)"'engineValves' must not be null");
        this.engineValves = new ArrayList<Valve>(engineValves);
    }

    @Override
    public void addEngineValves(Valve ... engineValves) {
        Assert.notNull((Object)engineValves, (String)"'engineValves' must not be null");
        this.engineValves.addAll(Arrays.asList(engineValves));
    }

    public Charset getUriEncoding() {
        return this.uriEncoding;
    }

    @Override
    public void setUriEncoding(Charset uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public int getBackgroundProcessorDelay() {
        return this.backgroundProcessorDelay;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        Assert.hasLength((String)protocol, (String)"'protocol' must not be empty");
        this.protocol = protocol;
    }

    public Collection<Valve> getContextValves() {
        return this.contextValves;
    }

    public void setContextValves(Collection<? extends Valve> contextValves) {
        Assert.notNull(contextValves, (String)"'contextValves' must not be null");
        this.contextValves = new ArrayList<Valve>(contextValves);
    }

    public void addContextValves(Valve ... contextValves) {
        Assert.notNull((Object)contextValves, (String)"'contextValves' must not be null");
        this.contextValves.addAll(Arrays.asList(contextValves));
    }

    public Collection<LifecycleListener> getContextLifecycleListeners() {
        return this.contextLifecycleListeners;
    }

    public void setContextLifecycleListeners(Collection<? extends LifecycleListener> contextLifecycleListeners) {
        Assert.notNull(contextLifecycleListeners, (String)"'contextLifecycleListeners' must not be null");
        this.contextLifecycleListeners = new ArrayList<LifecycleListener>(contextLifecycleListeners);
    }

    public void addContextLifecycleListeners(LifecycleListener ... contextLifecycleListeners) {
        Assert.notNull((Object)contextLifecycleListeners, (String)"'contextLifecycleListeners' must not be null");
        this.contextLifecycleListeners.addAll(Arrays.asList(contextLifecycleListeners));
    }

    public Collection<TomcatContextCustomizer> getContextCustomizers() {
        return this.contextCustomizers;
    }

    public void setContextCustomizers(Collection<? extends TomcatContextCustomizer> contextCustomizers) {
        Assert.notNull(contextCustomizers, (String)"'contextCustomizers' must not be null");
        this.contextCustomizers = new LinkedHashSet<TomcatContextCustomizer>(contextCustomizers);
    }

    @Override
    public void addContextCustomizers(TomcatContextCustomizer ... contextCustomizers) {
        Assert.notNull((Object)contextCustomizers, (String)"'contextCustomizers' must not be null");
        this.contextCustomizers.addAll(Arrays.asList(contextCustomizers));
    }

    public Set<TomcatConnectorCustomizer> getConnectorCustomizers() {
        return this.connectorCustomizers;
    }

    public void setConnectorCustomizers(Collection<? extends TomcatConnectorCustomizer> connectorCustomizers) {
        Assert.notNull(connectorCustomizers, (String)"'connectorCustomizers' must not be null");
        this.connectorCustomizers = new LinkedHashSet<TomcatConnectorCustomizer>(connectorCustomizers);
    }

    @Override
    public void addConnectorCustomizers(TomcatConnectorCustomizer ... connectorCustomizers) {
        Assert.notNull((Object)connectorCustomizers, (String)"'connectorCustomizers' must not be null");
        this.connectorCustomizers.addAll(Arrays.asList(connectorCustomizers));
    }

    public Set<TomcatProtocolHandlerCustomizer<?>> getProtocolHandlerCustomizers() {
        return this.protocolHandlerCustomizers;
    }

    public void setProtocolHandlerCustomizers(Collection<? extends TomcatProtocolHandlerCustomizer<?>> protocolHandlerCustomizers) {
        Assert.notNull(protocolHandlerCustomizers, (String)"'protocolHandlerCustomizers' must not be null");
        this.protocolHandlerCustomizers = new LinkedHashSet(protocolHandlerCustomizers);
    }

    @Override
    public void addProtocolHandlerCustomizers(TomcatProtocolHandlerCustomizer<?> ... protocolHandlerCustomizers) {
        Assert.notNull(protocolHandlerCustomizers, (String)"'protocolHandlerCustomizers' must not be null");
        this.protocolHandlerCustomizers.addAll(Arrays.asList(protocolHandlerCustomizers));
    }

    public List<Connector> getAdditionalConnectors() {
        return this.additionalConnectors;
    }

    public void setAdditionalConnectors(Collection<? extends Connector> additionalConnectors) {
        Assert.notNull(additionalConnectors, (String)"'additionalConnectors' must not be null");
        this.additionalConnectors = new ArrayList<Connector>(additionalConnectors);
    }

    public void addAdditionalConnectors(Connector ... connectors) {
        Assert.notNull((Object)connectors, (String)"'connectors' must not be null");
        this.additionalConnectors.addAll(Arrays.asList(connectors));
    }

    public boolean isDisableMBeanRegistry() {
        return this.disableMBeanRegistry;
    }

    @Override
    public void setDisableMBeanRegistry(boolean disableMBeanRegistry) {
        this.disableMBeanRegistry = disableMBeanRegistry;
    }

    @Override
    public void setUseApr(boolean useApr) {
        this.useApr = useApr;
    }

    @Deprecated(forRemoval=true, since="4.1.0")
    protected Tomcat createTomcat() {
        return this.createTomcat(new AbstractConfigurableWebServerFactory.TempDirs(this.getPort()));
    }

    protected Tomcat createTomcat(AbstractConfigurableWebServerFactory.TempDirs tempDirs) {
        if (this.isDisableMBeanRegistry()) {
            Registry.disableRegistry();
        }
        Tomcat tomcat = new Tomcat();
        File baseDir = this.getBaseDirectory() != null ? this.getBaseDirectory() : tempDirs.createTempDir("tomcat").toFile();
        tomcat.setBaseDir(baseDir.getAbsolutePath());
        for (LifecycleListener listener : this.getDefaultServerLifecycleListeners()) {
            tomcat.getServer().addLifecycleListener(listener);
        }
        tomcat.getServer().addLifecycleListener((LifecycleListener)new CleanTempDirsListener(tempDirs));
        Connector connector = new Connector(this.getProtocol());
        connector.setThrowOnFailure(true);
        tomcat.getService().addConnector(connector);
        this.customizeConnector(connector);
        tomcat.setConnector(connector);
        this.registerConnectorExecutor(tomcat, connector);
        tomcat.getHost().setAutoDeploy(false);
        this.configureEngine(tomcat.getEngine());
        for (Connector additionalConnector : this.getAdditionalConnectors()) {
            tomcat.getService().addConnector(additionalConnector);
            this.registerConnectorExecutor(tomcat, additionalConnector);
        }
        return tomcat;
    }

    protected void customizeConnector(Connector connector) {
        Ssl ssl;
        ProtocolHandler protocolHandler;
        int port = Math.max(this.getPort(), 0);
        connector.setPort(port);
        if (StringUtils.hasText((String)this.getServerHeader())) {
            connector.setProperty("server", this.getServerHeader());
        }
        if ((protocolHandler = connector.getProtocolHandler()) instanceof AbstractProtocol) {
            AbstractProtocol abstractProtocol = (AbstractProtocol)protocolHandler;
            this.customizeProtocol(abstractProtocol);
        }
        this.invokeProtocolHandlerCustomizers(connector.getProtocolHandler());
        if (this.getUriEncoding() != null) {
            connector.setURIEncoding(this.getUriEncoding().name());
        }
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        }
        if (Ssl.isEnabled((Ssl)(ssl = this.getSsl()))) {
            this.customizeSsl(connector, ssl);
        }
        CompressionConnectorCustomizer compression = new CompressionConnectorCustomizer(this.getCompression());
        compression.customize(connector);
        for (TomcatConnectorCustomizer customizer : this.getConnectorCustomizers()) {
            customizer.customize(connector);
        }
    }

    private void customizeProtocol(AbstractProtocol<?> protocol) {
        if (this.getAddress() != null) {
            protocol.setAddress(this.getAddress());
        }
    }

    private void invokeProtocolHandlerCustomizers(ProtocolHandler protocolHandler) {
        LambdaSafe.callbacks(TomcatProtocolHandlerCustomizer.class, this.getProtocolHandlerCustomizers(), (Object)protocolHandler, (Object[])new Object[0]).invoke(customizer -> customizer.customize(protocolHandler));
    }

    private void customizeSsl(Connector connector, Ssl ssl) {
        SslConnectorCustomizer customizer = new SslConnectorCustomizer(this.logger, connector, ssl.getClientAuth());
        customizer.customize(this.getSslBundle(), this.getServerNameSslBundles());
        this.addBundleUpdateHandler(null, ssl.getBundle(), customizer);
        ssl.getServerNameBundles().forEach(serverNameSslBundle -> this.addBundleUpdateHandler(serverNameSslBundle.serverName(), serverNameSslBundle.bundle(), customizer));
    }

    private void addBundleUpdateHandler(@Nullable String serverName, @Nullable String sslBundleName, SslConnectorCustomizer customizer) {
        if (StringUtils.hasText((String)sslBundleName)) {
            SslBundles sslBundles = this.getSslBundles();
            Assert.state((sslBundles != null ? 1 : 0) != 0, (String)"'sslBundles' must not be null");
            sslBundles.addBundleUpdateHandler(sslBundleName, sslBundle -> customizer.update(serverName, (SslBundle)sslBundle));
        }
    }

    private void registerConnectorExecutor(Tomcat tomcat, Connector connector) {
        Executor executor = connector.getProtocolHandler().getExecutor();
        if (executor instanceof org.apache.catalina.Executor) {
            org.apache.catalina.Executor executor2 = (org.apache.catalina.Executor)executor;
            tomcat.getService().addExecutor(executor2);
        }
    }

    private void configureEngine(Engine engine) {
        engine.setBackgroundProcessorDelay(this.getBackgroundProcessorDelay());
        for (Valve valve : this.getEngineValves()) {
            engine.getPipeline().addValve(valve);
        }
    }

    private static class CleanTempDirsListener
    implements LifecycleListener {
        private final AbstractConfigurableWebServerFactory.TempDirs tempDirs;

        CleanTempDirsListener(AbstractConfigurableWebServerFactory.TempDirs tempDirs) {
            this.tempDirs = tempDirs;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("after_destroy")) {
                this.tempDirs.cleanup();
            }
        }
    }
}

