/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.r2dbc;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.MSSQLR2DBCDatabaseContainer;
import org.testcontainers.containers.MSSQLServerContainer;

class SqlServerR2dbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<MSSQLServerContainer<?>, R2dbcConnectionDetails> {
    SqlServerR2dbcContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, "io.r2dbc.spi.ConnectionFactoryOptions");
    }

    @Override
    public R2dbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<MSSQLServerContainer<?>> source) {
        return new MsSqlServerR2dbcDatabaseContainerConnectionDetails(source);
    }

    private static final class MsSqlServerR2dbcDatabaseContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<MSSQLServerContainer<?>>
    implements R2dbcConnectionDetails {
        private MsSqlServerR2dbcDatabaseContainerConnectionDetails(ContainerConnectionSource<MSSQLServerContainer<?>> source) {
            super(source);
        }

        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return MSSQLR2DBCDatabaseContainer.getOptions((MSSQLServerContainer)((MSSQLServerContainer)this.getContainer()));
        }
    }
}

