/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.QualifierDefinition;
import org.springframework.util.ObjectUtils;

abstract class Definition {
    private static final int MULTIPLIER = 31;
    private final String name;
    private final MockReset reset;
    private final boolean proxyTargetAware;
    private final QualifierDefinition qualifier;

    Definition(String name, MockReset reset, boolean proxyTargetAware, QualifierDefinition qualifier) {
        this.name = name;
        this.reset = reset != null ? reset : MockReset.AFTER;
        this.proxyTargetAware = proxyTargetAware;
        this.qualifier = qualifier;
    }

    public String getName() {
        return this.name;
    }

    public MockReset getReset() {
        return this.reset;
    }

    public boolean isProxyTargetAware() {
        return this.proxyTargetAware;
    }

    public QualifierDefinition getQualifier() {
        return this.qualifier;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.name);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)((Object)this.reset));
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.proxyTargetAware);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.qualifier);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        Definition other = (Definition)obj;
        boolean result = true;
        result = result && ObjectUtils.nullSafeEquals((Object)this.name, (Object)other.name);
        result = result && ObjectUtils.nullSafeEquals((Object)((Object)this.reset), (Object)((Object)other.reset));
        result = result && ObjectUtils.nullSafeEquals((Object)this.proxyTargetAware, (Object)other.proxyTargetAware);
        result = result && ObjectUtils.nullSafeEquals((Object)this.qualifier, (Object)other.qualifier);
        return result;
    }
}

