/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.service.connection;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.springframework.boot.test.autoconfigure.service.connection.ServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ServiceConnectionContextCustomizer;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.testcontainers.containers.GenericContainer;

class ServiceConnectionContextCustomizerFactory
implements ContextCustomizerFactory {
    ServiceConnectionContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        ArrayList sources = new ArrayList();
        ReflectionUtils.doWithFields(testClass, field -> {
            MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)field);
            annotations.stream(ServiceConnection.class).forEach(annotation -> sources.add(this.createSource(field, (MergedAnnotation<ServiceConnection>)annotation)));
        });
        return sources.isEmpty() ? null : new ServiceConnectionContextCustomizer(sources);
    }

    private ContainerConnectionSource<?, ?, ?> createSource(Field field, MergedAnnotation<ServiceConnection> annotation) {
        Class<? extends ConnectionDetails> connectionDetailsType = this.getConnectionDetailsType(annotation);
        Object fieldValue = this.getFieldValue(field);
        Assert.isInstanceOf(GenericContainer.class, (Object)fieldValue, (String)"Field %s must be a %s".formatted(field.getName(), GenericContainer.class.getName()));
        GenericContainer container = (GenericContainer)fieldValue;
        return new ContainerConnectionSource<MergedAnnotation<ServiceConnection>, ConnectionDetails, GenericContainer>(connectionDetailsType, field, annotation, container);
    }

    private Class<? extends ConnectionDetails> getConnectionDetailsType(MergedAnnotation<ServiceConnection> annotation) {
        return annotation.getClass("value");
    }

    private Object getFieldValue(Field field) {
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, null);
    }
}

