/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.service.connection;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactories;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;

class ServiceConnectionContextCustomizer
implements ContextCustomizer {
    private final ConnectionDetailsFactories factories = new ConnectionDetailsFactories();
    private final List<ContainerConnectionSource<?, ?, ?>> sources;

    ServiceConnectionContextCustomizer(List<ContainerConnectionSource<?, ?, ?>> sources) {
        this.sources = sources;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            this.registerServiceConnections(registry);
        }
    }

    private void registerServiceConnections(BeanDefinitionRegistry registry) {
        this.sources.forEach(source -> this.registerServiceConnection(registry, (ContainerConnectionSource<?, ?, ?>)source));
    }

    private void registerServiceConnection(BeanDefinitionRegistry registry, ContainerConnectionSource<?, ?, ?> source) {
        ConnectionDetails connectionDetails = this.getConnectionDetails(source);
        String beanName = source.getBeanName();
        registry.registerBeanDefinition(beanName, this.createBeanDefinition(connectionDetails));
    }

    private <S> ConnectionDetails getConnectionDetails(S source) {
        ConnectionDetailsFactory factory = this.factories.getConnectionDetailsFactory(source);
        ConnectionDetails connectionDetails = factory.getConnectionDetails(source);
        Assert.state((connectionDetails != null ? 1 : 0) != 0, () -> "No connection details created by %s".formatted(factory.getClass().getName()));
        return connectionDetails;
    }

    private <T> BeanDefinition createBeanDefinition(T instance) {
        return new RootBeanDefinition(instance.getClass(), () -> instance);
    }
}

