/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.service.connection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.boot.test.autoconfigure.service.connection.AnnotatedFieldOrigin;
import org.springframework.boot.test.autoconfigure.service.connection.ServiceConnection;
import org.springframework.core.annotation.MergedAnnotation;
import org.testcontainers.containers.GenericContainer;

public final class ContainerConnectionSource<A extends Annotation, D extends ConnectionDetails, C extends GenericContainer<?>>
implements OriginProvider {
    private final Class<D> connectionDetailsType;
    private final Field field;
    private final A annotation;
    private final C container;
    private final AnnotatedFieldOrigin origin;

    ContainerConnectionSource(Class<D> connectionDetailsType, Field field, MergedAnnotation<ServiceConnection> annotation, C container) {
        this(connectionDetailsType, field, annotation.getRoot().synthesize(), container);
    }

    ContainerConnectionSource(Class<D> connectionDetailsType, Field field, A annotation, C container) {
        this.connectionDetailsType = connectionDetailsType;
        this.field = field;
        this.annotation = annotation;
        this.container = container;
        this.origin = new AnnotatedFieldOrigin(field, (Annotation)annotation);
    }

    boolean accepts(Class<?> annotationType, Class<?> connectionDetailsType, Class<?> containerType) {
        return annotationType.isInstance(this.annotation) && connectionDetailsType.isAssignableFrom(this.connectionDetailsType) && containerType.isInstance(this.container);
    }

    String getBeanName() {
        return this.field.getName() + this.connectionDetailsType.getSimpleName() + "ConnectedContainer";
    }

    public A getAnnotation() {
        return this.annotation;
    }

    public C getContainer() {
        return this.container;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public String toString() {
        return "ServiceConnectedContainer for %s".formatted(this.origin);
    }
}

