/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.service.connection;

import java.lang.annotation.Annotation;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactory;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.testcontainers.containers.GenericContainer;

public abstract class ContainerConnectionDetailsFactory<A extends Annotation, D extends ConnectionDetails, C extends GenericContainer<?>>
implements ConnectionDetailsFactory<ContainerConnectionSource<A, D, C>, D> {
    public final D getConnectionDetails(ContainerConnectionSource<A, D, C> source) {
        Class<?> containerType;
        Class<?> connectionDetailsType;
        Class<?>[] generics = this.resolveGenerics();
        Class<?> annotationType = generics[0];
        return !source.accepts(annotationType, connectionDetailsType = generics[1], containerType = generics[2]) ? null : (D)this.getContainerConnectionDetails(source);
    }

    private Class<?>[] resolveGenerics() {
        return ResolvableType.forClass(ContainerConnectionDetailsFactory.class, this.getClass()).resolveGenerics();
    }

    protected abstract D getContainerConnectionDetails(ContainerConnectionSource<A, D, C> var1);

    protected static class ContainerConnectionDetails
    implements ConnectionDetails,
    OriginProvider {
        private final Origin origin;

        protected ContainerConnectionDetails(ContainerConnectionSource<?, ?, ?> source) {
            Assert.notNull(source, (String)"Source must not be null");
            this.origin = source.getOrigin();
        }

        public Origin getOrigin() {
            return this.origin;
        }
    }
}

