/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.r2dbc;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.test.autoconfigure.r2dbc.R2dbcServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.MSSQLR2DBCDatabaseContainer;
import org.testcontainers.containers.MSSQLServerContainer;

class SqlServerR2dbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<R2dbcServiceConnection, R2dbcConnectionDetails, MSSQLServerContainer<?>> {
    SqlServerR2dbcContainerConnectionDetailsFactory() {
    }

    @Override
    public R2dbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<R2dbcServiceConnection, R2dbcConnectionDetails, MSSQLServerContainer<?>> source) {
        return new R2dbcDatabaseContainerConnectionDetails(source.getContainer());
    }

    private static final class R2dbcDatabaseContainerConnectionDetails
    implements R2dbcConnectionDetails {
        private final MSSQLServerContainer<?> container;

        private R2dbcDatabaseContainerConnectionDetails(MSSQLServerContainer<?> container) {
            this.container = container;
        }

        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return MSSQLR2DBCDatabaseContainer.getOptions(this.container);
        }
    }
}

