/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.r2dbc;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.test.autoconfigure.r2dbc.R2dbcServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.PostgreSQLR2DBCDatabaseContainer;

class PostgresR2dbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<R2dbcServiceConnection, R2dbcConnectionDetails, PostgreSQLContainer<?>> {
    PostgresR2dbcContainerConnectionDetailsFactory() {
    }

    @Override
    public R2dbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<R2dbcServiceConnection, R2dbcConnectionDetails, PostgreSQLContainer<?>> source) {
        return new R2dbcDatabaseContainerConnectionDetails(source.getContainer());
    }

    private static final class R2dbcDatabaseContainerConnectionDetails
    implements R2dbcConnectionDetails {
        private final PostgreSQLContainer<?> container;

        private R2dbcDatabaseContainerConnectionDetails(PostgreSQLContainer<?> container) {
            this.container = container;
        }

        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return PostgreSQLR2DBCDatabaseContainer.getOptions(this.container);
        }
    }
}

