/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.r2dbc;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.test.autoconfigure.r2dbc.R2dbcServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.MySQLR2DBCDatabaseContainer;

class MySqlR2dbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<R2dbcServiceConnection, R2dbcConnectionDetails, MySQLContainer<?>> {
    MySqlR2dbcContainerConnectionDetailsFactory() {
    }

    @Override
    public R2dbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<R2dbcServiceConnection, R2dbcConnectionDetails, MySQLContainer<?>> source) {
        return new R2dbcDatabaseContainerConnectionDetails(source.getContainer());
    }

    private static final class R2dbcDatabaseContainerConnectionDetails
    implements R2dbcConnectionDetails {
        private final MySQLContainer<?> container;

        private R2dbcDatabaseContainerConnectionDetails(MySQLContainer<?> container) {
            this.container = container;
        }

        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return MySQLR2DBCDatabaseContainer.getOptions(this.container);
        }
    }
}

