/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.neo4j;

import java.net.URI;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.springframework.boot.autoconfigure.neo4j.Neo4jConnectionDetails;
import org.springframework.boot.test.autoconfigure.neo4j.Neo4jServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Neo4jContainer;

class Neo4jContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Neo4jServiceConnection, Neo4jConnectionDetails, Neo4jContainer<?>> {
    Neo4jContainerConnectionDetailsFactory() {
    }

    @Override
    protected Neo4jConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Neo4jServiceConnection, Neo4jConnectionDetails, Neo4jContainer<?>> source) {
        return new Neo4jContainerConnectionDetails(source);
    }

    private static final class Neo4jContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails
    implements Neo4jConnectionDetails {
        private final Neo4jContainer<?> container;

        private Neo4jContainerConnectionDetails(ContainerConnectionSource<Neo4jServiceConnection, Neo4jConnectionDetails, Neo4jContainer<?>> source) {
            super(source);
            this.container = source.getContainer();
        }

        public URI getUri() {
            return URI.create(this.container.getBoltUrl());
        }

        public AuthToken getAuthToken() {
            String password = this.container.getAdminPassword();
            return password != null ? AuthTokens.basic((String)"neo4j", (String)password) : AuthTokens.none();
        }
    }
}

