/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.mongo;

import com.mongodb.ConnectionString;
import org.springframework.boot.autoconfigure.mongo.MongoConnectionDetails;
import org.springframework.boot.test.autoconfigure.mongo.MongoServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.MongoDBContainer;

class MongoContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<MongoServiceConnection, MongoConnectionDetails, MongoDBContainer> {
    MongoContainerConnectionDetailsFactory() {
    }

    @Override
    protected MongoConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<MongoServiceConnection, MongoConnectionDetails, MongoDBContainer> source) {
        return new MongoContainerConnectionDetails(source);
    }

    private static final class MongoContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails
    implements MongoConnectionDetails {
        private final ConnectionString connectionString;

        private MongoContainerConnectionDetails(ContainerConnectionSource<MongoServiceConnection, MongoConnectionDetails, MongoDBContainer> source) {
            super(source);
            this.connectionString = new ConnectionString(source.getContainer().getReplicaSetUrl());
        }

        public ConnectionString getConnectionString() {
            return this.connectionString;
        }
    }
}

