/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.kafka;

import java.net.URI;
import java.util.List;
import org.springframework.boot.autoconfigure.kafka.KafkaConnectionDetails;
import org.springframework.boot.test.autoconfigure.kafka.KafkaServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.KafkaContainer;

class KafkaContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<KafkaServiceConnection, KafkaConnectionDetails, KafkaContainer> {
    KafkaContainerConnectionDetailsFactory() {
    }

    @Override
    protected KafkaConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<KafkaServiceConnection, KafkaConnectionDetails, KafkaContainer> source) {
        return new KafkaContainerConnectionDetails(source);
    }

    private static final class KafkaContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails
    implements KafkaConnectionDetails {
        private final KafkaContainer container;

        private KafkaContainerConnectionDetails(ContainerConnectionSource<KafkaServiceConnection, KafkaConnectionDetails, KafkaContainer> source) {
            super(source);
            this.container = source.getContainer();
        }

        public List<KafkaConnectionDetails.Node> getBootstrapNodes() {
            URI uri = URI.create(this.container.getBootstrapServers());
            return List.of(new KafkaConnectionDetails.Node(uri.getHost(), uri.getPort()));
        }
    }
}

