/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.jdbc;

import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.test.autoconfigure.jdbc.JdbcServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.JdbcDatabaseContainer;

class JdbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<JdbcServiceConnection, JdbcConnectionDetails, JdbcDatabaseContainer<?>> {
    JdbcContainerConnectionDetailsFactory() {
    }

    @Override
    protected JdbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<JdbcServiceConnection, JdbcConnectionDetails, JdbcDatabaseContainer<?>> source) {
        return new JdbcContainerConnectionDetails(source);
    }

    private static final class JdbcContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails
    implements JdbcConnectionDetails {
        private final JdbcDatabaseContainer<?> container;

        private JdbcContainerConnectionDetails(ContainerConnectionSource<JdbcServiceConnection, JdbcConnectionDetails, JdbcDatabaseContainer<?>> source) {
            super(source);
            this.container = source.getContainer();
        }

        public String getUsername() {
            return this.container.getUsername();
        }

        public String getPassword() {
            return this.container.getPassword();
        }

        public String getJdbcUrl() {
            return this.container.getJdbcUrl();
        }

        public String getDriverClassName() {
            return this.container.getDriverClassName();
        }
    }
}

