/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.influx;

import java.net.URI;
import org.springframework.boot.autoconfigure.influx.InfluxDbConnectionDetails;
import org.springframework.boot.test.autoconfigure.influx.InfluxDbServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.InfluxDBContainer;

class InfluxDbContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<InfluxDbServiceConnection, InfluxDbConnectionDetails, InfluxDBContainer<?>> {
    InfluxDbContainerConnectionDetailsFactory() {
    }

    @Override
    protected InfluxDbConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<InfluxDbServiceConnection, InfluxDbConnectionDetails, InfluxDBContainer<?>> source) {
        return new InfluxDbContainerConnectionDetails(source);
    }

    private static final class InfluxDbContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails
    implements InfluxDbConnectionDetails {
        private final InfluxDBContainer<?> container;

        private InfluxDbContainerConnectionDetails(ContainerConnectionSource<InfluxDbServiceConnection, InfluxDbConnectionDetails, InfluxDBContainer<?>> source) {
            super(source);
            this.container = source.getContainer();
        }

        public String getUsername() {
            return this.container.getUsername();
        }

        public String getPassword() {
            return this.container.getPassword();
        }

        public URI getUrl() {
            return URI.create(this.container.getUrl());
        }
    }
}

