/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.elasticsearch;

import java.util.List;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchConnectionDetails;
import org.springframework.boot.test.autoconfigure.elasticsearch.ElasticsearchServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.GenericContainer;

class ElasticsearchContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<ElasticsearchServiceConnection, ElasticsearchConnectionDetails, GenericContainer<?>> {
    private static final int DEFAULT_PORT = 9200;

    ElasticsearchContainerConnectionDetailsFactory() {
    }

    @Override
    protected ElasticsearchConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<ElasticsearchServiceConnection, ElasticsearchConnectionDetails, GenericContainer<?>> source) {
        return new ElasticsearchContainerConnectionDetails(source);
    }

    private static final class ElasticsearchContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails
    implements ElasticsearchConnectionDetails {
        private final List<ElasticsearchConnectionDetails.Node> nodes;

        private ElasticsearchContainerConnectionDetails(ContainerConnectionSource<ElasticsearchServiceConnection, ElasticsearchConnectionDetails, GenericContainer<?>> source) {
            super(source);
            this.nodes = List.of(new ElasticsearchConnectionDetails.Node(source.getContainer().getHost(), source.getContainer().getMappedPort(9200).intValue(), ElasticsearchConnectionDetails.Node.Protocol.HTTP, null, null));
        }

        public List<ElasticsearchConnectionDetails.Node> getNodes() {
            return this.nodes;
        }
    }
}

