/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.data.redis;

import org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails;
import org.springframework.boot.test.autoconfigure.data.redis.RedisServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.GenericContainer;

class RedisContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<RedisServiceConnection, RedisConnectionDetails, GenericContainer<?>> {
    RedisContainerConnectionDetailsFactory() {
    }

    @Override
    public RedisConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<RedisServiceConnection, RedisConnectionDetails, GenericContainer<?>> source) {
        return new RedisContainerConnectionDetails(source);
    }

    private static final class RedisContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails
    implements RedisConnectionDetails {
        private final RedisConnectionDetails.Standalone standalone;

        private RedisContainerConnectionDetails(final ContainerConnectionSource<RedisServiceConnection, RedisConnectionDetails, GenericContainer<?>> source) {
            super(source);
            this.standalone = new RedisConnectionDetails.Standalone(){

                public String getHost() {
                    return source.getContainer().getHost();
                }

                public int getPort() {
                    return source.getContainer().getFirstMappedPort();
                }
            };
        }

        public RedisConnectionDetails.Standalone getStandalone() {
            return this.standalone;
        }
    }
}

