/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.couchbase;

import org.springframework.boot.autoconfigure.couchbase.CouchbaseConnectionDetails;
import org.springframework.boot.test.autoconfigure.couchbase.CouchbaseServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.couchbase.CouchbaseContainer;

class CouchbaseContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<CouchbaseServiceConnection, CouchbaseConnectionDetails, CouchbaseContainer> {
    CouchbaseContainerConnectionDetailsFactory() {
    }

    @Override
    protected CouchbaseConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<CouchbaseServiceConnection, CouchbaseConnectionDetails, CouchbaseContainer> source) {
        return new CouchbaseContainerConnectionDetails(source);
    }

    private static final class CouchbaseContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails
    implements CouchbaseConnectionDetails {
        private final CouchbaseContainer container;

        private CouchbaseContainerConnectionDetails(ContainerConnectionSource<CouchbaseServiceConnection, CouchbaseConnectionDetails, CouchbaseContainer> source) {
            super(source);
            this.container = source.getContainer();
        }

        public String getUsername() {
            return this.container.getUsername();
        }

        public String getPassword() {
            return this.container.getPassword();
        }

        public String getConnectionString() {
            return this.container.getConnectionString();
        }
    }
}

