/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.cassandra;

import java.util.List;
import org.springframework.boot.autoconfigure.cassandra.CassandraConnectionDetails;
import org.springframework.boot.test.autoconfigure.cassandra.CassandraServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.CassandraContainer;

class CassandraContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<CassandraServiceConnection, CassandraConnectionDetails, CassandraContainer<?>> {
    CassandraContainerConnectionDetailsFactory() {
    }

    @Override
    protected CassandraConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<CassandraServiceConnection, CassandraConnectionDetails, CassandraContainer<?>> source) {
        return new CassandraContainerConnectionDetails(source);
    }

    private static final class CassandraContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails
    implements CassandraConnectionDetails {
        private final CassandraContainer<?> container;

        private CassandraContainerConnectionDetails(ContainerConnectionSource<CassandraServiceConnection, CassandraConnectionDetails, CassandraContainer<?>> source) {
            super(source);
            this.container = source.getContainer();
        }

        public List<CassandraConnectionDetails.Node> getContactPoints() {
            return List.of(new CassandraConnectionDetails.Node(this.container.getContactPoint().getHostString(), this.container.getContactPoint().getPort()));
        }

        public String getUsername() {
            return this.container.getUsername();
        }

        public String getPassword() {
            return this.container.getPassword();
        }

        public String getLocalDatacenter() {
            return this.container.getLocalDatacenter();
        }
    }
}

