/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.amqp;

import java.net.URI;
import java.util.List;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionDetails;
import org.springframework.boot.test.autoconfigure.amqp.RabbitServiceConnection;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.test.autoconfigure.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.RabbitMQContainer;

class RabbitContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<RabbitServiceConnection, RabbitConnectionDetails, RabbitMQContainer> {
    RabbitContainerConnectionDetailsFactory() {
    }

    @Override
    protected RabbitConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<RabbitServiceConnection, RabbitConnectionDetails, RabbitMQContainer> source) {
        return new RabbitMqContainerConnectionDetails(source);
    }

    private static final class RabbitMqContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails
    implements RabbitConnectionDetails {
        private final RabbitMQContainer container;

        private RabbitMqContainerConnectionDetails(ContainerConnectionSource<RabbitServiceConnection, RabbitConnectionDetails, RabbitMQContainer> source) {
            super(source);
            this.container = source.getContainer();
        }

        public String getUsername() {
            return this.container.getAdminUsername();
        }

        public String getPassword() {
            return this.container.getAdminPassword();
        }

        public String getVirtualHost() {
            return null;
        }

        public List<RabbitConnectionDetails.Address> getAddresses() {
            URI uri = URI.create(this.container.getAmqpUrl());
            return List.of(new RabbitConnectionDetails.Address(uri.getHost(), uri.getPort()));
        }
    }
}

