/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.actuate.observability;

import io.micrometer.tracing.Tracer;
import java.util.List;
import java.util.Objects;
import org.springframework.aot.AotDetector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.test.autoconfigure.actuate.observability.AutoConfigureObservability;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.util.ClassUtils;

class ObservabilityContextCustomizerFactory
implements ContextCustomizerFactory {
    ObservabilityContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        AutoConfigureObservability annotation = (AutoConfigureObservability)TestContextAnnotationUtils.findMergedAnnotation(testClass, AutoConfigureObservability.class);
        if (annotation == null) {
            return new DisableObservabilityContextCustomizer(true, true);
        }
        return new DisableObservabilityContextCustomizer(!annotation.metrics(), !annotation.tracing());
    }

    private static class DisableObservabilityContextCustomizer
    implements ContextCustomizer {
        private final boolean disableMetrics;
        private final boolean disableTracing;

        DisableObservabilityContextCustomizer(boolean disableMetrics, boolean disableTracing) {
            this.disableMetrics = disableMetrics;
            this.disableTracing = disableTracing;
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
            if (this.disableMetrics) {
                TestPropertyValues.of((String[])new String[]{"management.defaults.metrics.export.enabled=false", "management.simple.metrics.export.enabled=true"}).applyTo(context);
            }
            if (this.disableTracing) {
                TestPropertyValues.of((String[])new String[]{"management.tracing.enabled=false"}).applyTo(context);
                this.registerNoopTracer(context);
            }
        }

        private void registerNoopTracer(ConfigurableApplicationContext context) {
            if (AotDetector.useGeneratedArtifacts()) {
                return;
            }
            if (!ClassUtils.isPresent((String)"io.micrometer.tracing.Tracer", (ClassLoader)context.getClassLoader())) {
                return;
            }
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            if (beanFactory instanceof BeanDefinitionRegistry) {
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
                this.registerNoopTracer(registry);
            }
        }

        private void registerNoopTracer(BeanDefinitionRegistry registry) {
            RootBeanDefinition definition = new RootBeanDefinition(NoopTracerRegistrar.class);
            definition.setRole(2);
            registry.registerBeanDefinition(NoopTracerRegistrar.class.getName(), (BeanDefinition)definition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisableObservabilityContextCustomizer that = (DisableObservabilityContextCustomizer)o;
            return this.disableMetrics == that.disableMetrics && this.disableTracing == that.disableTracing;
        }

        public int hashCode() {
            return Objects.hash(this.disableMetrics, this.disableTracing);
        }
    }

    static class NoopTracerFactoryBean
    implements FactoryBean<Tracer> {
        NoopTracerFactoryBean() {
        }

        public Tracer getObject() {
            return Tracer.NOOP;
        }

        public Class<?> getObjectType() {
            return Tracer.class;
        }
    }

    static class NoopTracerRegistrar
    implements BeanDefinitionRegistryPostProcessor,
    Ordered,
    BeanFactoryAware {
        private BeanFactory beanFactory;

        NoopTracerRegistrar() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (AotDetector.useGeneratedArtifacts()) {
                return;
            }
            if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)this.beanFactory), Tracer.class, (boolean)false, (boolean)false).length == 0) {
                registry.registerBeanDefinition("noopTracer", (BeanDefinition)new RootBeanDefinition(NoopTracerFactoryBean.class));
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

