/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.actuate.observability;

import java.util.List;
import java.util.Objects;
import org.springframework.boot.test.autoconfigure.actuate.observability.AutoConfigureObservability;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;

class ObservabilityContextCustomizerFactory
implements ContextCustomizerFactory {
    ObservabilityContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        AutoConfigureObservability annotation = (AutoConfigureObservability)TestContextAnnotationUtils.findMergedAnnotation(testClass, AutoConfigureObservability.class);
        if (annotation == null) {
            return new DisableObservabilityContextCustomizer(true, true);
        }
        return new DisableObservabilityContextCustomizer(!annotation.metrics(), !annotation.tracing());
    }

    static class DisableObservabilityContextCustomizer
    implements ContextCustomizer {
        private final boolean disableMetrics;
        private final boolean disableTracing;

        DisableObservabilityContextCustomizer(boolean disableMetrics, boolean disableTracing) {
            this.disableMetrics = disableMetrics;
            this.disableTracing = disableTracing;
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
            if (this.disableMetrics) {
                TestPropertyValues.of((String[])new String[]{"management.defaults.metrics.export.enabled=false", "management.simple.metrics.export.enabled=true"}).applyTo(context);
            }
            if (this.disableTracing) {
                TestPropertyValues.of((String[])new String[]{"management.tracing.enabled=false"}).applyTo(context);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisableObservabilityContextCustomizer that = (DisableObservabilityContextCustomizer)o;
            return this.disableMetrics == that.disableMetrics && this.disableTracing == that.disableTracing;
        }

        public int hashCode() {
            return Objects.hash(this.disableMetrics, this.disableTracing);
        }
    }
}

