/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import javax.json.bind.Jsonb;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.jsonb.JsonbAutoConfiguration;
import org.springframework.boot.test.json.AbstractJsonMarshalTester;
import org.springframework.boot.test.json.BasicJsonTester;
import org.springframework.boot.test.json.GsonTester;
import org.springframework.boot.test.json.JacksonTester;
import org.springframework.boot.test.json.JsonbTester;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.ResolvableType;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.ReflectionUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"org.assertj.core.api.Assert"})
@ConditionalOnProperty(value={"spring.test.jsontesters.enabled"})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class, GsonAutoConfiguration.class, JsonbAutoConfiguration.class})
public class JsonTestersAutoConfiguration {
    @Bean
    public static JsonMarshalTestersBeanPostProcessor jsonMarshalTestersBeanPostProcessor() {
        return new JsonMarshalTestersBeanPostProcessor();
    }

    @Bean
    @Scope(value="prototype")
    public FactoryBean<BasicJsonTester> basicJsonTesterFactoryBean() {
        return new JsonTesterFactoryBean(BasicJsonTester.class, null);
    }

    static class JsonMarshalTestersBeanPostProcessor
    extends InstantiationAwareBeanPostProcessorAdapter {
        JsonMarshalTestersBeanPostProcessor() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            ReflectionUtils.doWithFields(bean.getClass(), field -> this.processField(bean, field));
            return bean;
        }

        private void processField(Object bean, Field field) {
            if (AbstractJsonMarshalTester.class.isAssignableFrom(field.getType())) {
                this.initializeTester(bean, field, bean.getClass(), ResolvableType.forField((Field)field).getGeneric(new int[0]));
            } else if (BasicJsonTester.class.isAssignableFrom(field.getType())) {
                this.initializeTester(bean, field, bean.getClass());
            }
        }

        private void initializeTester(Object bean, Field field, Object ... args) {
            ReflectionUtils.makeAccessible((Field)field);
            Object tester = ReflectionUtils.getField((Field)field, (Object)bean);
            if (tester != null) {
                ReflectionTestUtils.invokeMethod((Object)tester, (String)"initialize", (Object[])args);
            }
        }
    }

    static class JsonTesterFactoryBean<T, M>
    implements FactoryBean<T> {
        private final Class<?> objectType;
        private final M marshaller;

        JsonTesterFactoryBean(Class<?> objectType, M marshaller) {
            this.objectType = objectType;
            this.marshaller = marshaller;
        }

        public boolean isSingleton() {
            return false;
        }

        public T getObject() throws Exception {
            Constructor<?>[] constructors;
            if (this.marshaller == null) {
                Constructor<?> constructor = this.objectType.getDeclaredConstructor(new Class[0]);
                ReflectionUtils.makeAccessible(constructor);
                return (T)BeanUtils.instantiateClass(constructor, (Object[])new Object[0]);
            }
            for (Constructor<?> constructor : constructors = this.objectType.getDeclaredConstructors()) {
                if (constructor.getParameterCount() != 1 || !constructor.getParameterTypes()[0].isInstance(this.marshaller)) continue;
                ReflectionUtils.makeAccessible(constructor);
                return (T)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{this.marshaller});
            }
            throw new IllegalStateException(this.objectType + " does not have a usable constructor");
        }

        public Class<?> getObjectType() {
            return this.objectType;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Jsonb.class})
    static class JsonbJsonTesterConfiguration {
        JsonbJsonTesterConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnBean(value={Jsonb.class})
        FactoryBean<JsonbTester<?>> jsonbTesterFactoryBean(Jsonb jsonb) {
            return new JsonTesterFactoryBean(JsonbTester.class, jsonb);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Gson.class})
    static class GsonJsonTestersConfiguration {
        GsonJsonTestersConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnBean(value={Gson.class})
        FactoryBean<GsonTester<?>> gsonTesterFactoryBean(Gson gson) {
            return new JsonTesterFactoryBean(GsonTester.class, gson);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    static class JacksonJsonTestersConfiguration {
        JacksonJsonTestersConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnBean(value={ObjectMapper.class})
        FactoryBean<JacksonTester<?>> jacksonTesterFactoryBean(ObjectMapper mapper) {
            return new JsonTesterFactoryBean(JacksonTester.class, mapper);
        }
    }
}

