/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.restdocs;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.autoconfigure.restdocs.RestDocsMockMvcBuilderCustomizer;
import org.springframework.boot.test.autoconfigure.restdocs.RestDocsMockMvcConfigurationCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentation;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentationConfigurer;
import org.springframework.restdocs.mockmvc.RestDocumentationResultHandler;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties
public class RestDocsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MockMvcRestDocumentationConfigurer.class})
    public MockMvcRestDocumentationConfigurer restDocsMockMvcConfigurer(ObjectProvider<RestDocsMockMvcConfigurationCustomizer> configurationCustomizerProvider, RestDocumentationContextProvider contextProvider) {
        MockMvcRestDocumentationConfigurer configurer = MockMvcRestDocumentation.documentationConfiguration((RestDocumentationContextProvider)contextProvider);
        RestDocsMockMvcConfigurationCustomizer configurationCustomizer = (RestDocsMockMvcConfigurationCustomizer)configurationCustomizerProvider.getIfAvailable();
        if (configurationCustomizer != null) {
            configurationCustomizer.customize(configurer);
        }
        return configurer;
    }

    @Bean
    @ConfigurationProperties(prefix="spring.test.restdocs")
    public RestDocsMockMvcBuilderCustomizer restDocumentationConfigurer(MockMvcRestDocumentationConfigurer configurer, ObjectProvider<RestDocumentationResultHandler> resultHandler) {
        return new RestDocsMockMvcBuilderCustomizer(configurer, (RestDocumentationResultHandler)resultHandler.getIfAvailable());
    }
}

