/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.session.jdbc.autoconfigure;

import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.session.autoconfigure.SessionAutoConfiguration;
import org.springframework.boot.session.autoconfigure.SessionProperties;
import org.springframework.boot.session.jdbc.autoconfigure.JdbcSessionDataSourceScriptDatabaseInitializer;
import org.springframework.boot.session.jdbc.autoconfigure.JdbcSessionProperties;
import org.springframework.boot.sql.autoconfigure.init.OnDatabaseInitializationCondition;
import org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.jdbc.JdbcIndexedSessionRepository;
import org.springframework.session.jdbc.config.annotation.SpringSessionDataSource;
import org.springframework.session.jdbc.config.annotation.web.http.JdbcHttpSessionConfiguration;

@AutoConfiguration(before={SessionAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Session.class, JdbcTemplate.class, JdbcIndexedSessionRepository.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={DataSource.class})
@EnableConfigurationProperties(value={JdbcSessionProperties.class, SessionProperties.class})
@Import(value={DatabaseInitializationDependencyConfigurer.class, JdbcHttpSessionConfiguration.class})
public class JdbcSessionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={OnJdbcSessionDatasourceInitializationCondition.class})
    JdbcSessionDataSourceScriptDatabaseInitializer jdbcSessionDataSourceScriptDatabaseInitializer(@SpringSessionDataSource ObjectProvider<DataSource> sessionDataSource, ObjectProvider<DataSource> dataSource, JdbcSessionProperties properties) {
        DataSource dataSourceToInitialize = (DataSource)sessionDataSource.getIfAvailable(() -> dataSource.getObject());
        return new JdbcSessionDataSourceScriptDatabaseInitializer(dataSourceToInitialize, properties);
    }

    @Bean
    @Order(value=-2147483648)
    SessionRepositoryCustomizer<JdbcIndexedSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, JdbcSessionProperties jdbcSessionProperties, ServerProperties serverProperties) {
        return sessionRepository -> {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from((Object)sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout())).to(arg_0 -> ((JdbcIndexedSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
            map.from(jdbcSessionProperties::getTableName).to(arg_0 -> ((JdbcIndexedSessionRepository)sessionRepository).setTableName(arg_0));
            map.from(jdbcSessionProperties::getFlushMode).to(arg_0 -> ((JdbcIndexedSessionRepository)sessionRepository).setFlushMode(arg_0));
            map.from(jdbcSessionProperties::getSaveMode).to(arg_0 -> ((JdbcIndexedSessionRepository)sessionRepository).setSaveMode(arg_0));
            map.from(jdbcSessionProperties::getCleanupCron).to(arg_0 -> ((JdbcIndexedSessionRepository)sessionRepository).setCleanupCron(arg_0));
        };
    }

    static class OnJdbcSessionDatasourceInitializationCondition
    extends OnDatabaseInitializationCondition {
        OnJdbcSessionDatasourceInitializationCondition() {
            super("Jdbc Session", new String[]{"spring.session.jdbc.initialize-schema"});
        }
    }
}

