/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.session.data.redis.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.boot.data.redis.autoconfigure.RedisAutoConfiguration;
import org.springframework.boot.data.redis.autoconfigure.RedisReactiveAutoConfiguration;
import org.springframework.boot.session.autoconfigure.SessionAutoConfiguration;
import org.springframework.boot.session.autoconfigure.SessionProperties;
import org.springframework.boot.session.data.redis.autoconfigure.RedisSessionProperties;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.ReactiveSessionRepositoryCustomizer;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.data.redis.ReactiveRedisIndexedSessionRepository;
import org.springframework.session.data.redis.ReactiveRedisSessionRepository;
import org.springframework.session.data.redis.RedisIndexedSessionRepository;
import org.springframework.session.data.redis.RedisSessionRepository;
import org.springframework.session.data.redis.config.ConfigureNotifyKeyspaceEventsAction;
import org.springframework.session.data.redis.config.ConfigureReactiveRedisAction;
import org.springframework.session.data.redis.config.ConfigureRedisAction;
import org.springframework.session.data.redis.config.annotation.ConfigureNotifyKeyspaceEventsReactiveAction;
import org.springframework.session.data.redis.config.annotation.web.http.RedisHttpSessionConfiguration;
import org.springframework.session.data.redis.config.annotation.web.http.RedisIndexedHttpSessionConfiguration;
import org.springframework.session.data.redis.config.annotation.web.server.RedisIndexedWebSessionConfiguration;
import org.springframework.session.data.redis.config.annotation.web.server.RedisWebSessionConfiguration;

@AutoConfiguration(before={SessionAutoConfiguration.class}, beforeName={"org.springframework.boot.webflux.autoconfigure.HttpHandlerAutoConfiguration", "org.springframework.boot.webflux.autoconfigure.WebFluxAutoConfiguration"}, after={RedisAutoConfiguration.class, RedisReactiveAutoConfiguration.class}, afterName={"org.springframework.boot.webflux.autoconfigure.WebSessionIdResolverAutoConfiguration"})
@ConditionalOnClass(value={Session.class})
@EnableConfigurationProperties(value={RedisSessionProperties.class, ServerProperties.class, SessionProperties.class})
public final class RedisSessionAutoConfiguration {

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ReactiveRedisConnectionFactory.class, ReactiveRedisSessionRepository.class})
    @ConditionalOnMissingBean(value={ReactiveSessionRepository.class})
    @ConditionalOnBean(value={ReactiveRedisConnectionFactory.class})
    class ReactiveRedisSessionConfiguration {
        ReactiveRedisSessionConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnProperty(name={"spring.session.redis.repository-type"}, havingValue="indexed")
        @Import(value={RedisIndexedWebSessionConfiguration.class})
        static class IndexedRedisSessionConfiguration {
            IndexedRedisSessionConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            ConfigureReactiveRedisAction configureReactiveRedisAction(RedisSessionProperties redisSessionProperties) {
                return switch (redisSessionProperties.getConfigureAction()) {
                    default -> throw new IncompatibleClassChangeError();
                    case RedisSessionProperties.ConfigureAction.NOTIFY_KEYSPACE_EVENTS -> new ConfigureNotifyKeyspaceEventsReactiveAction();
                    case RedisSessionProperties.ConfigureAction.NONE -> ConfigureReactiveRedisAction.NO_OP;
                };
            }

            @Bean
            ReactiveSessionRepositoryCustomizer<ReactiveRedisIndexedSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, RedisSessionProperties redisSessionProperties, ServerProperties serverProperties) {
                return sessionRepository -> {
                    PropertyMapper map = PropertyMapper.get();
                    map.from((Object)sessionProperties.determineTimeout(() -> serverProperties.getReactive().getSession().getTimeout())).to(arg_0 -> ((ReactiveRedisIndexedSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
                    map.from(redisSessionProperties::getNamespace).to(arg_0 -> ((ReactiveRedisIndexedSessionRepository)sessionRepository).setRedisKeyNamespace(arg_0));
                    map.from(redisSessionProperties::getSaveMode).to(arg_0 -> ((ReactiveRedisIndexedSessionRepository)sessionRepository).setSaveMode(arg_0));
                };
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnProperty(name={"spring.session.redis.repository-type"}, havingValue="default", matchIfMissing=true)
        @Import(value={RedisWebSessionConfiguration.class})
        static class DefaultRedisSessionConfiguration {
            DefaultRedisSessionConfiguration() {
            }

            @Bean
            ReactiveSessionRepositoryCustomizer<ReactiveRedisSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, RedisSessionProperties redisSessionProperties, ServerProperties serverProperties) {
                return sessionRepository -> {
                    PropertyMapper map = PropertyMapper.get();
                    map.from((Object)sessionProperties.determineTimeout(() -> serverProperties.getReactive().getSession().getTimeout())).to(arg_0 -> ((ReactiveRedisSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
                    map.from(redisSessionProperties::getNamespace).to(arg_0 -> ((ReactiveRedisSessionRepository)sessionRepository).setRedisKeyNamespace(arg_0));
                    map.from(redisSessionProperties::getSaveMode).to(arg_0 -> ((ReactiveRedisSessionRepository)sessionRepository).setSaveMode(arg_0));
                };
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RedisTemplate.class, RedisIndexedSessionRepository.class})
    @ConditionalOnMissingBean(value={SessionRepository.class})
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class ServletRedisSessionConfiguration {
        ServletRedisSessionConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnProperty(name={"spring.session.redis.repository-type"}, havingValue="indexed")
        @Import(value={RedisIndexedHttpSessionConfiguration.class})
        static class IndexedRedisSessionConfiguration {
            IndexedRedisSessionConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            ConfigureRedisAction configureRedisAction(RedisSessionProperties redisSessionProperties) {
                return switch (redisSessionProperties.getConfigureAction()) {
                    default -> throw new IncompatibleClassChangeError();
                    case RedisSessionProperties.ConfigureAction.NOTIFY_KEYSPACE_EVENTS -> new ConfigureNotifyKeyspaceEventsAction();
                    case RedisSessionProperties.ConfigureAction.NONE -> ConfigureRedisAction.NO_OP;
                };
            }

            @Bean
            @Order(value=-2147483648)
            SessionRepositoryCustomizer<RedisIndexedSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, RedisSessionProperties redisSessionProperties, ServerProperties serverProperties) {
                return sessionRepository -> {
                    PropertyMapper map = PropertyMapper.get();
                    map.from((Object)sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout())).to(arg_0 -> ((RedisIndexedSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
                    map.from(redisSessionProperties::getNamespace).to(arg_0 -> ((RedisIndexedSessionRepository)sessionRepository).setRedisKeyNamespace(arg_0));
                    map.from(redisSessionProperties::getFlushMode).to(arg_0 -> ((RedisIndexedSessionRepository)sessionRepository).setFlushMode(arg_0));
                    map.from(redisSessionProperties::getSaveMode).to(arg_0 -> ((RedisIndexedSessionRepository)sessionRepository).setSaveMode(arg_0));
                    map.from(redisSessionProperties::getCleanupCron).to(arg_0 -> ((RedisIndexedSessionRepository)sessionRepository).setCleanupCron(arg_0));
                };
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnProperty(name={"spring.session.redis.repository-type"}, havingValue="default", matchIfMissing=true)
        @Import(value={RedisHttpSessionConfiguration.class})
        static class DefaultRedisSessionConfiguration {
            DefaultRedisSessionConfiguration() {
            }

            @Bean
            @Order(value=-2147483648)
            SessionRepositoryCustomizer<RedisSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, RedisSessionProperties redisSessionProperties, ServerProperties serverProperties) {
                String cleanupCron = redisSessionProperties.getCleanupCron();
                if (cleanupCron != null) {
                    throw new InvalidConfigurationPropertyValueException("spring.session.redis.cleanup-cron", (Object)cleanupCron, "Cron-based cleanup is only supported when spring.session.redis.repository-type is set to indexed.");
                }
                return sessionRepository -> {
                    PropertyMapper map = PropertyMapper.get();
                    map.from((Object)sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout())).to(arg_0 -> ((RedisSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
                    map.from(redisSessionProperties::getNamespace).to(arg_0 -> ((RedisSessionRepository)sessionRepository).setRedisKeyNamespace(arg_0));
                    map.from(redisSessionProperties::getFlushMode).to(arg_0 -> ((RedisSessionRepository)sessionRepository).setFlushMode(arg_0));
                    map.from(redisSessionProperties::getSaveMode).to(arg_0 -> ((RedisSessionRepository)sessionRepository).setSaveMode(arg_0));
                };
            }
        }
    }
}

