/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.session.data.mongodb.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.data.mongodb.autoconfigure.MongoDataAutoConfiguration;
import org.springframework.boot.data.mongodb.autoconfigure.MongoReactiveDataAutoConfiguration;
import org.springframework.boot.session.autoconfigure.SessionAutoConfiguration;
import org.springframework.boot.session.autoconfigure.SessionProperties;
import org.springframework.boot.session.data.mongodb.autoconfigure.MongoSessionProperties;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.ReactiveSessionRepositoryCustomizer;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.data.mongo.MongoIndexedSessionRepository;
import org.springframework.session.data.mongo.ReactiveMongoSessionRepository;
import org.springframework.session.data.mongo.config.annotation.web.http.MongoHttpSessionConfiguration;
import org.springframework.session.data.mongo.config.annotation.web.reactive.ReactiveMongoWebSessionConfiguration;

@AutoConfiguration(before={SessionAutoConfiguration.class}, beforeName={"org.springframework.boot.webflux.autoconfigure.HttpHandlerAutoConfiguration", "org.springframework.boot.webflux.autoconfigure.WebFluxAutoConfiguration"}, after={MongoDataAutoConfiguration.class, MongoReactiveDataAutoConfiguration.class}, afterName={"org.springframework.boot.webflux.autoconfigure.WebSessionIdResolverAutoConfiguration"})
@ConditionalOnClass(value={Session.class})
@EnableConfigurationProperties(value={MongoSessionProperties.class})
public class MongoSessionAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ReactiveMongoOperations.class, ReactiveMongoSessionRepository.class})
    @ConditionalOnMissingBean(value={ReactiveSessionRepository.class})
    @ConditionalOnBean(value={ReactiveMongoOperations.class})
    @Import(value={ReactiveMongoWebSessionConfiguration.class})
    class ReactiveMongoSessionConfiguration {
        ReactiveMongoSessionConfiguration() {
        }

        @Bean
        ReactiveSessionRepositoryCustomizer<ReactiveMongoSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, MongoSessionProperties mongoSessionProperties, ServerProperties serverProperties) {
            return sessionRepository -> {
                PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
                map.from((Object)sessionProperties.determineTimeout(() -> serverProperties.getReactive().getSession().getTimeout())).to(arg_0 -> ((ReactiveMongoSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
                map.from(mongoSessionProperties::getCollectionName).to(arg_0 -> ((ReactiveMongoSessionRepository)sessionRepository).setCollectionName(arg_0));
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={MongoOperations.class, MongoIndexedSessionRepository.class})
    @ConditionalOnBean(value={MongoOperations.class})
    @ConditionalOnMissingBean(value={SessionRepository.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Import(value={MongoHttpSessionConfiguration.class})
    class ServletMongoSessionConfiguration {
        ServletMongoSessionConfiguration() {
        }

        @Bean
        @Order(value=-2147483648)
        SessionRepositoryCustomizer<MongoIndexedSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, MongoSessionProperties mongoSessionProperties, ServerProperties serverProperties) {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            return sessionRepository -> {
                map.from((Object)sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout())).to(arg_0 -> ((MongoIndexedSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
                map.from(mongoSessionProperties::getCollectionName).to(arg_0 -> ((MongoIndexedSessionRepository)sessionRepository).setCollectionName(arg_0));
            };
        }
    }
}

