/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.servlet.autoconfigure.actuate.web;

import jakarta.servlet.Servlet;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.servlet.autoconfigure.actuate.web.ManagementServletContext;
import org.springframework.boot.servlet.filter.ApplicationContextHeaderFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@ConditionalOnClass(value={Servlet.class, WebEndpointProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={WebEndpointProperties.class})
public class ServletManagementContextAutoConfiguration {
    @Bean
    public ManagementServletContext managementServletContext(WebEndpointProperties properties) {
        return () -> ((WebEndpointProperties)properties).getBasePath();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBooleanProperty(value={"management.server.add-application-context-header"})
    protected static class ApplicationContextFilterConfiguration {
        protected ApplicationContextFilterConfiguration() {
        }

        @Bean
        public ApplicationContextHeaderFilter applicationContextIdFilter(ApplicationContext context) {
            return new ApplicationContextHeaderFilter(context);
        }
    }
}

