/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.autoconfigure.web.servlet;

import jakarta.servlet.DispatcherType;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.security.autoconfigure.web.servlet.SecurityFilterProperties;
import org.springframework.boot.security.autoconfigure.web.servlet.ServletWebSecurityAutoConfiguration;
import org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.context.AbstractSecurityWebApplicationInitializer;

@AutoConfiguration(after={ServletWebSecurityAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={SecurityFilterProperties.class})
@ConditionalOnClass(value={AbstractSecurityWebApplicationInitializer.class, SessionCreationPolicy.class})
public final class SecurityFilterAutoConfiguration {
    private static final String DEFAULT_FILTER_NAME = "springSecurityFilterChain";

    @Bean
    @ConditionalOnBean(name={"springSecurityFilterChain"})
    DelegatingFilterProxyRegistrationBean securityFilterChainRegistration(SecurityFilterProperties securityFilterProperties) {
        DelegatingFilterProxyRegistrationBean registration = new DelegatingFilterProxyRegistrationBean(DEFAULT_FILTER_NAME, new ServletRegistrationBean[0]);
        registration.setOrder(securityFilterProperties.getOrder());
        registration.setDispatcherTypes(this.getDispatcherTypes(securityFilterProperties));
        return registration;
    }

    private @Nullable EnumSet<DispatcherType> getDispatcherTypes(SecurityFilterProperties securityFilterProperties) {
        if (securityFilterProperties.getDispatcherTypes() == null) {
            return null;
        }
        return securityFilterProperties.getDispatcherTypes().stream().map(type -> DispatcherType.valueOf((String)type.name())).collect(Collectors.toCollection(() -> EnumSet.noneOf(DispatcherType.class)));
    }
}

