/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.test.autoconfigure.webmvc;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.webmvc.test.autoconfigure.MockMvcBuilderCustomizer;
import org.springframework.boot.webmvc.test.autoconfigure.MockMvcHtmlUnitDriverCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.concurrent.DelegatingSecurityContextExecutor;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.test.web.servlet.setup.MockMvcConfigurerAdapter;
import org.springframework.web.context.WebApplicationContext;

@AutoConfiguration
@ConditionalOnClass(value={MockMvc.class})
public final class SecurityMockMvcAutoConfiguration {
    private static final String DEFAULT_SECURITY_FILTER_NAME = "springSecurityFilterChain";

    @Bean
    @ConditionalOnBean(name={"springSecurityFilterChain"})
    SecurityMockMvcBuilderCustomizer securityMockMvcBuilderCustomizer() {
        return new SecurityMockMvcBuilderCustomizer();
    }

    static class SecurityMockMvcBuilderCustomizer
    implements MockMvcBuilderCustomizer {
        SecurityMockMvcBuilderCustomizer() {
        }

        public void customize(ConfigurableMockMvcBuilder<?> builder) {
            builder.apply((MockMvcConfigurer)new MockMvcConfigurerAdapter(){

                public RequestPostProcessor beforeMockMvcCreated(ConfigurableMockMvcBuilder<?> builder, WebApplicationContext context) {
                    return SecurityMockMvcRequestPostProcessors.testSecurityContext();
                }
            });
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HtmlUnitDriver.class})
    static class SecurityMockMvcHtmlUnitDriverConfiguration {
        SecurityMockMvcHtmlUnitDriverConfiguration() {
        }

        MockMvcHtmlUnitDriverCustomizer securityDelegateMockMvcHtmlUnitDriverCustomizer() {
            return driver -> driver.setExecutor((Executor)new DelegatingSecurityContextExecutor((Executor)Executors.newSingleThreadExecutor()));
        }
    }
}

