/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.loader.Launcher;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.archive.FilteredArchive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.boot.loader.util.AsciiBytes;
import org.springframework.boot.loader.util.SystemPropertyUtils;

public class PropertiesLauncher
extends Launcher {
    private final Logger logger = Logger.getLogger(Launcher.class.getName());
    public static final String MAIN = "loader.main";
    public static final String PATH = "loader.path";
    public static final String HOME = "loader.home";
    public static final String ARGS = "loader.args";
    public static final String CONFIG_NAME = "loader.config.name";
    public static final String CONFIG_LOCATION = "loader.config.location";
    public static final String SET_SYSTEM_PROPERTIES = "loader.system";
    private static final List<String> DEFAULT_PATHS = Arrays.asList("lib/");
    private static final Pattern WORD_SEPARATOR = Pattern.compile("\\W+");
    private static final URL[] EMPTY_URLS = new URL[0];
    private final File home;
    private List<String> paths = new ArrayList<String>(DEFAULT_PATHS);
    private final Properties properties = new Properties();

    public PropertiesLauncher() {
        if (!this.isDebug()) {
            this.logger.setLevel(Level.SEVERE);
        }
        try {
            this.home = this.getHomeDirectory();
            this.initializeProperties(this.home);
            this.initializePaths();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private boolean isDebug() {
        String debug = System.getProperty("debug");
        if (debug != null && !"false".equals(debug)) {
            return true;
        }
        debug = System.getProperty("DEBUG");
        if (debug != null && !"false".equals(debug)) {
            return true;
        }
        debug = System.getenv("DEBUG");
        return debug != null && !"false".equals(debug);
    }

    protected File getHomeDirectory() {
        return new File(SystemPropertyUtils.resolvePlaceholders(System.getProperty(HOME, "${user.dir}")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeProperties(File home) throws Exception, IOException {
        String config = "classpath:" + SystemPropertyUtils.resolvePlaceholders(SystemPropertyUtils.getProperty(CONFIG_NAME, "application")) + ".properties";
        InputStream resource = this.getResource(config = SystemPropertyUtils.resolvePlaceholders(SystemPropertyUtils.getProperty(CONFIG_LOCATION, config)));
        if (resource != null) {
            this.logger.info("Found: " + config);
            try {
                this.properties.load(resource);
            }
            finally {
                resource.close();
            }
            for (Object key : Collections.list(this.properties.propertyNames())) {
                String text = this.properties.getProperty((String)key);
                String value = SystemPropertyUtils.resolvePlaceholders(this.properties, text);
                if (value == null) continue;
                this.properties.put(key, value);
            }
            if (SystemPropertyUtils.resolvePlaceholders("${loader.system:false}").equals("true")) {
                this.logger.info("Adding resolved properties to System properties");
                for (Object key : Collections.list(this.properties.propertyNames())) {
                    String value = this.properties.getProperty((String)key);
                    System.setProperty((String)key, value);
                }
            }
        } else {
            this.logger.info("Not found: " + config);
        }
    }

    private InputStream getResource(String config) throws Exception {
        if (config.startsWith("classpath:")) {
            return this.getClasspathResource(config.substring("classpath:".length()));
        }
        if (this.isUrl(config = this.stripFileUrlPrefix(config))) {
            return this.getURLResource(config);
        }
        return this.getFileResource(config);
    }

    private String stripFileUrlPrefix(String config) {
        if (config.startsWith("file:") && (config = config.substring("file:".length())).startsWith("//")) {
            config = config.substring(2);
        }
        return config;
    }

    private boolean isUrl(String config) {
        return config.contains("://");
    }

    private InputStream getClasspathResource(String config) {
        while (config.startsWith("/")) {
            config = config.substring(1);
        }
        config = "/" + config;
        this.logger.fine("Trying classpath: " + config);
        return this.getClass().getResourceAsStream(config);
    }

    private InputStream getFileResource(String config) throws Exception {
        File file = new File(config);
        this.logger.fine("Trying file: " + config);
        if (file.canRead()) {
            return new FileInputStream(file);
        }
        return null;
    }

    private InputStream getURLResource(String config) throws Exception {
        URL url = new URL(config);
        if (this.exists(url)) {
            URLConnection con = url.openConnection();
            try {
                return con.getInputStream();
            }
            catch (IOException ex) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                throw ex;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        try {
            connection.setUseCaches(connection.getClass().getSimpleName().startsWith("JNLP"));
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                httpConnection.setRequestMethod("HEAD");
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == 200) {
                    boolean bl = true;
                    return bl;
                }
                if (responseCode == 404) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = connection.getContentLength() >= 0;
            return bl;
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    private void initializePaths() throws IOException {
        String path = SystemPropertyUtils.getProperty(PATH);
        if (path == null) {
            path = this.properties.getProperty(PATH);
        }
        if (path != null) {
            this.paths = this.parsePathsProperty(SystemPropertyUtils.resolvePlaceholders(path));
        }
        this.logger.info("Nested archive paths: " + this.paths);
    }

    private List<String> parsePathsProperty(String commaSeparatedPaths) {
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : commaSeparatedPaths.split(",")) {
            if ((path = this.cleanupPath(path)).equals(".") || path.equals("")) continue;
            paths.add(path);
        }
        if (paths.isEmpty()) {
            paths.add(".");
        }
        return paths;
    }

    protected String[] getArgs(String ... args) throws Exception {
        String loaderArgs = this.getProperty(ARGS);
        if (loaderArgs != null) {
            String[] defaultArgs = loaderArgs.split("\\s+");
            String[] additionalArgs = args;
            args = new String[defaultArgs.length + additionalArgs.length];
            System.arraycopy(defaultArgs, 0, args, 0, defaultArgs.length);
            System.arraycopy(additionalArgs, 0, args, defaultArgs.length, additionalArgs.length);
        }
        return args;
    }

    @Override
    protected String getMainClass() throws Exception {
        String mainClass = this.getProperty(MAIN, "Start-Class");
        if (mainClass == null) {
            throw new IllegalStateException("No 'loader.main' or 'Start-Class' specified");
        }
        return mainClass;
    }

    @Override
    protected ClassLoader createClassLoader(List<Archive> archives) throws Exception {
        ClassLoader loader = super.createClassLoader(archives);
        String customLoaderClassName = this.getProperty("loader.classLoader");
        if (customLoaderClassName != null) {
            loader = this.wrapWithCustomClassLoader(loader, customLoaderClassName);
            this.logger.info("Using custom class loader: " + customLoaderClassName);
        }
        return loader;
    }

    private ClassLoader wrapWithCustomClassLoader(ClassLoader parent, String loaderClassName) throws Exception {
        Class<?> loaderClass = Class.forName(loaderClassName, true, parent);
        try {
            return (ClassLoader)loaderClass.getConstructor(ClassLoader.class).newInstance(parent);
        }
        catch (NoSuchMethodException ex) {
            try {
                return (ClassLoader)loaderClass.getConstructor(URL[].class, ClassLoader.class).newInstance(new URL[0], parent);
            }
            catch (NoSuchMethodException ex2) {
                return (ClassLoader)loaderClass.newInstance();
            }
        }
    }

    private String getProperty(String propertyKey) throws Exception {
        return this.getProperty(propertyKey, null);
    }

    private String getProperty(String propertyKey, String manifestKey) throws Exception {
        String value;
        Manifest manifest;
        String property;
        if (manifestKey == null) {
            manifestKey = propertyKey.replace(".", "-");
            manifestKey = PropertiesLauncher.toCamelCase(manifestKey);
        }
        if ((property = SystemPropertyUtils.getProperty(propertyKey)) != null) {
            String value2 = SystemPropertyUtils.resolvePlaceholders(property);
            this.logger.fine("Property '" + propertyKey + "' from environment: " + value2);
            return value2;
        }
        if (this.properties.containsKey(propertyKey)) {
            String value3 = SystemPropertyUtils.resolvePlaceholders(this.properties.getProperty(propertyKey));
            this.logger.fine("Property '" + propertyKey + "' from properties: " + value3);
            return value3;
        }
        try {
            manifest = new ExplodedArchive(this.home).getManifest();
            if (manifest != null) {
                String value4 = manifest.getMainAttributes().getValue(manifestKey);
                this.logger.fine("Property '" + manifestKey + "' from home directory manifest: " + value4);
                return value4;
            }
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        manifest = this.createArchive().getManifest();
        if (manifest != null && (value = manifest.getMainAttributes().getValue(manifestKey)) != null) {
            this.logger.fine("Property '" + manifestKey + "' from archive manifest: " + value);
            return value;
        }
        return null;
    }

    @Override
    protected List<Archive> getClassPathArchives() throws Exception {
        ArrayList<Archive> lib = new ArrayList<Archive>();
        for (String path : this.paths) {
            for (Archive archive : this.getClassPathArchives(path)) {
                ArrayList<Archive> nested = new ArrayList<Archive>(archive.getNestedArchives(new ArchiveEntryFilter()));
                nested.add(0, archive);
                lib.addAll(nested);
            }
        }
        this.addParentClassLoaderEntries(lib);
        return lib;
    }

    private List<Archive> getClassPathArchives(String path) throws Exception {
        Archive nested;
        Archive archive;
        String root = this.cleanupPath(this.stripFileUrlPrefix(path));
        ArrayList<Archive> lib = new ArrayList<Archive>();
        File file = new File(root);
        if (!root.startsWith("/")) {
            file = new File(this.home, root);
        }
        if (file.isDirectory()) {
            this.logger.info("Adding classpath entries from " + file);
            archive = new ExplodedArchive(file, false);
            lib.add(archive);
        }
        if ((archive = this.getArchive(file)) != null) {
            this.logger.info("Adding classpath entries from archive " + archive.getUrl() + root);
            lib.add(archive);
        }
        if ((nested = this.getNestedArchive(root)) != null) {
            this.logger.info("Adding classpath entries from nested " + nested.getUrl() + root);
            lib.add(nested);
        }
        return lib;
    }

    private Archive getArchive(File file) throws IOException {
        String name = file.getName().toLowerCase();
        if (name.endsWith(".jar") || name.endsWith(".zip")) {
            return new JarFileArchive(file);
        }
        return null;
    }

    private Archive getNestedArchive(String root) throws Exception {
        Archive parent = this.createArchive();
        if (root.startsWith("/") || parent.getUrl().equals(this.home.toURI().toURL())) {
            return null;
        }
        PrefixMatchingArchiveFilter filter = new PrefixMatchingArchiveFilter(root);
        if (parent.getNestedArchives(filter).isEmpty()) {
            return null;
        }
        return new FilteredArchive(parent, filter);
    }

    private void addParentClassLoaderEntries(List<Archive> lib) throws IOException, URISyntaxException {
        ClassLoader parentClassLoader = this.getClass().getClassLoader();
        for (URL url : this.getURLs(parentClassLoader)) {
            if (url.toString().endsWith(".jar") || url.toString().endsWith(".zip")) {
                lib.add(0, new JarFileArchive(new File(url.toURI())));
                continue;
            }
            if (url.toString().endsWith("/*")) {
                String name = url.getFile();
                File dir = new File(name.substring(0, name.length() - 1));
                if (!dir.exists()) continue;
                lib.add(0, new ExplodedArchive(new File(name.substring(0, name.length() - 1)), false));
                continue;
            }
            lib.add(0, new ExplodedArchive(new File(url.getFile())));
        }
    }

    private URL[] getURLs(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            return ((URLClassLoader)classLoader).getURLs();
        }
        return EMPTY_URLS;
    }

    private String cleanupPath(String path) {
        if ((path = path.trim()).toLowerCase().endsWith(".jar") || path.toLowerCase().endsWith(".zip")) {
            return path;
        }
        if (path.endsWith("/*")) {
            path = path.substring(0, path.length() - 1);
        } else if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        return path;
    }

    public static void main(String[] args) throws Exception {
        PropertiesLauncher launcher = new PropertiesLauncher();
        args = launcher.getArgs(args);
        launcher.launch(args);
    }

    public static String toCamelCase(CharSequence string) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Matcher matcher = WORD_SEPARATOR.matcher(string);
        int pos = 0;
        while (matcher.find()) {
            builder.append(PropertiesLauncher.capitalize(string.subSequence(pos, matcher.end()).toString()));
            pos = matcher.end();
        }
        builder.append(PropertiesLauncher.capitalize(string.subSequence(pos, string.length()).toString()));
        return builder.toString();
    }

    private static Object capitalize(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        sb.append(Character.toUpperCase(str.charAt(0)));
        sb.append(str.substring(1));
        return sb.toString();
    }

    private static final class PrefixMatchingArchiveFilter
    implements Archive.EntryFilter {
        private final AsciiBytes prefix;
        private final ArchiveEntryFilter filter = new ArchiveEntryFilter();

        private PrefixMatchingArchiveFilter(String prefix) {
            this.prefix = new AsciiBytes(prefix);
        }

        @Override
        public boolean matches(Archive.Entry entry) {
            return entry.getName().startsWith(this.prefix) && this.filter.matches(entry);
        }
    }

    private static final class ArchiveEntryFilter
    implements Archive.EntryFilter {
        private static final AsciiBytes DOT_JAR = new AsciiBytes(".jar");
        private static final AsciiBytes DOT_ZIP = new AsciiBytes(".zip");

        private ArchiveEntryFilter() {
        }

        @Override
        public boolean matches(Archive.Entry entry) {
            return entry.isDirectory() || entry.getName().endsWith(DOT_JAR) || entry.getName().endsWith(DOT_ZIP);
        }
    }
}

