/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.boot.loader.util.AsciiBytes;

public class ExplodedArchive
extends Archive {
    private static final Set<String> SKIPPED_NAMES = new HashSet<String>(Arrays.asList(".", ".."));
    private static final AsciiBytes MANIFEST_ENTRY_NAME = new AsciiBytes("META-INF/MANIFEST.MF");
    private final File root;
    private Map<AsciiBytes, Archive.Entry> entries = new LinkedHashMap<AsciiBytes, Archive.Entry>();
    private Manifest manifest;
    private boolean recursive = true;

    public ExplodedArchive(File root) {
        this(root, true);
    }

    public ExplodedArchive(File root, boolean recursive) {
        if (!root.exists() || !root.isDirectory()) {
            throw new IllegalArgumentException("Invalid source folder " + root);
        }
        this.root = root;
        this.recursive = recursive;
        this.buildEntries(root);
        this.entries = Collections.unmodifiableMap(this.entries);
    }

    private ExplodedArchive(File root, Map<AsciiBytes, Archive.Entry> entries) {
        this.root = root;
        this.entries = Collections.unmodifiableMap(entries);
    }

    private void buildEntries(File file) {
        if (!file.equals(this.root)) {
            String name = file.toURI().getPath().substring(this.root.toURI().getPath().length());
            FileEntry entry = new FileEntry(new AsciiBytes(name), file);
            this.entries.put(entry.getName(), entry);
        }
        if (file.isDirectory() && this.recursive) {
            for (File child : file.listFiles()) {
                if (SKIPPED_NAMES.contains(child.getName())) continue;
                this.buildEntries(child);
            }
        }
    }

    @Override
    public URL getUrl() throws MalformedURLException {
        FilteredURLStreamHandler handler = new FilteredURLStreamHandler();
        return new URL("file", "", -1, this.root.toURI().getPath(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        if (this.manifest == null && this.entries.containsKey(MANIFEST_ENTRY_NAME)) {
            FileEntry entry = (FileEntry)this.entries.get(MANIFEST_ENTRY_NAME);
            FileInputStream inputStream = new FileInputStream(entry.getFile());
            try {
                this.manifest = new Manifest(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        return this.manifest;
    }

    @Override
    public List<Archive> getNestedArchives(Archive.EntryFilter filter) throws IOException {
        ArrayList<Archive> nestedArchives = new ArrayList<Archive>();
        for (Archive.Entry entry : this.getEntries()) {
            if (!filter.matches(entry)) continue;
            nestedArchives.add(this.getNestedArchive(entry));
        }
        return Collections.unmodifiableList(nestedArchives);
    }

    @Override
    public Collection<Archive.Entry> getEntries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    protected Archive getNestedArchive(Archive.Entry entry) throws IOException {
        File file = ((FileEntry)entry).getFile();
        return file.isDirectory() ? new ExplodedArchive(file) : new JarFileArchive(file);
    }

    @Override
    public Archive getFilteredArchive(Archive.EntryRenameFilter filter) throws IOException {
        LinkedHashMap<AsciiBytes, Archive.Entry> filteredEntries = new LinkedHashMap<AsciiBytes, Archive.Entry>();
        for (Map.Entry<AsciiBytes, Archive.Entry> entry : this.entries.entrySet()) {
            AsciiBytes filteredName = filter.apply(entry.getKey(), entry.getValue());
            if (filteredName == null) continue;
            filteredEntries.put(filteredName, new FileEntry(filteredName, ((FileEntry)entry.getValue()).getFile()));
        }
        return new ExplodedArchive(this.root, filteredEntries);
    }

    private static class FileNotFoundURLConnection
    extends URLConnection {
        private final String name;

        public FileNotFoundURLConnection(URL url, String name) {
            super(url);
            this.name = name;
        }

        @Override
        public void connect() throws IOException {
            throw new FileNotFoundException(this.name);
        }
    }

    private class FilteredURLStreamHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            String name = url.getPath().substring(ExplodedArchive.this.root.toURI().getPath().length());
            if (ExplodedArchive.this.entries.containsKey(new AsciiBytes(name))) {
                return new URL(url.toString()).openConnection();
            }
            return new FileNotFoundURLConnection(url, name);
        }
    }

    private class FileEntry
    implements Archive.Entry {
        private final AsciiBytes name;
        private final File file;

        public FileEntry(AsciiBytes name, File file) {
            this.name = name;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public AsciiBytes getName() {
            return this.name;
        }
    }
}

