/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.jar;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.boot.loader.jar.JarEntry;
import org.springframework.boot.loader.jar.JarEntryData;
import org.springframework.boot.loader.jar.JarFile;

class JarURLConnection
extends java.net.JarURLConnection {
    private static final String JAR_URL_POSTFIX = "!/";
    private static final String JAR_URL_PREFIX = "jar:file:";
    private final JarFile jarFile;
    private JarEntryData jarEntryData;
    private String jarEntryName;
    private String contentType;

    protected JarURLConnection(URL url, JarFile jarFile) throws MalformedURLException {
        super(new URL(JarURLConnection.buildRootUrl(jarFile)));
        this.jarFile = jarFile;
        String spec = url.getFile();
        int separator = spec.lastIndexOf(JAR_URL_POSTFIX);
        if (separator == -1) {
            throw new MalformedURLException("no !/ found in url spec:" + spec);
        }
        if (separator + 2 != spec.length()) {
            this.jarEntryName = spec.substring(separator + 2);
        }
    }

    @Override
    public void connect() throws IOException {
        if (this.jarEntryName != null) {
            this.jarEntryData = this.jarFile.getJarEntryData(this.jarEntryName);
            if (this.jarEntryData == null) {
                throw new FileNotFoundException("JAR entry " + this.jarEntryName + " not found in " + this.jarFile.getName());
            }
        }
        this.connected = true;
    }

    @Override
    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntryData == null ? null : this.jarEntryData.asJarEntry();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this.jarEntryName == null) {
            throw new IOException("no entry name specified");
        }
        return this.jarEntryData.getInputStream();
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
            return this.jarEntryData == null ? this.jarFile.size() : this.jarEntryData.getSize();
        }
        catch (IOException ex) {
            return -1;
        }
    }

    @Override
    public Object getContent() throws IOException {
        this.connect();
        return this.jarEntryData == null ? this.jarFile : super.getContent();
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            this.contentType = this.jarEntryName == null ? "x-java/jar" : null;
            this.contentType = this.contentType == null ? JarURLConnection.guessContentTypeFromName(this.jarEntryName) : this.contentType;
            this.contentType = this.contentType == null ? "content/unknown" : this.contentType;
        }
        return this.contentType;
    }

    private static String buildRootUrl(JarFile jarFile) {
        String path = jarFile.getRootJarFile().getFile().getPath();
        StringBuilder builder = new StringBuilder(JAR_URL_PREFIX.length() + path.length() + JAR_URL_POSTFIX.length());
        builder.append(JAR_URL_PREFIX);
        builder.append(path);
        builder.append(JAR_URL_POSTFIX);
        return builder.toString();
    }
}

