/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.archive;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import org.springframework.boot.loader.AsciiBytes;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.jar.JarEntryData;
import org.springframework.boot.loader.jar.JarEntryFilter;
import org.springframework.boot.loader.jar.JarFile;

public class JarFileArchive
extends Archive {
    private final JarFile jarFile;
    private final List<Archive.Entry> entries;

    public JarFileArchive(File file) throws IOException {
        this(new JarFile(file, new JarEntryFilter[0]));
    }

    public JarFileArchive(JarFile jarFile) {
        this.jarFile = jarFile;
        ArrayList<JarFileEntry> jarFileEntries = new ArrayList<JarFileEntry>();
        for (JarEntryData data : jarFile) {
            jarFileEntries.add(new JarFileEntry(data));
        }
        this.entries = Collections.unmodifiableList(jarFileEntries);
    }

    @Override
    public URL getUrl() throws MalformedURLException {
        return this.jarFile.getUrl();
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    @Override
    public List<Archive> getNestedArchives(Archive.EntryFilter filter) throws IOException {
        ArrayList<Archive> nestedArchives = new ArrayList<Archive>();
        for (Archive.Entry entry : this.getEntries()) {
            if (!filter.matches(entry)) continue;
            nestedArchives.add(this.getNestedArchive(entry));
        }
        return Collections.unmodifiableList(nestedArchives);
    }

    @Override
    public Collection<Archive.Entry> getEntries() {
        return Collections.unmodifiableCollection(this.entries);
    }

    protected Archive getNestedArchive(Archive.Entry entry) throws IOException {
        JarEntryData data = ((JarFileEntry)entry).getJarEntryData();
        JarFile jarFile = this.jarFile.getNestedJarFile(data, new JarEntryFilter[0]);
        return new JarFileArchive(jarFile);
    }

    @Override
    public Archive getFilteredArchive(final Archive.EntryRenameFilter filter) throws IOException {
        JarFile filteredJar = this.jarFile.getFilteredJarFile(new JarEntryFilter(){

            @Override
            public AsciiBytes apply(AsciiBytes name, JarEntryData entryData) {
                return filter.apply(name, new JarFileEntry(entryData));
            }
        });
        return new JarFileArchive(filteredJar);
    }

    private static class JarFileEntry
    implements Archive.Entry {
        private final JarEntryData entryData;

        public JarFileEntry(JarEntryData entryData) {
            this.entryData = entryData;
        }

        public JarEntryData getJarEntryData() {
            return this.entryData;
        }

        @Override
        public boolean isDirectory() {
            return this.entryData.isDirectory();
        }

        @Override
        public AsciiBytes getName() {
            return this.entryData.getName();
        }
    }
}

