/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.jar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.springframework.boot.loader.AsciiBytes;
import org.springframework.boot.loader.data.RandomAccessData;
import org.springframework.boot.loader.data.RandomAccessDataFile;
import org.springframework.boot.loader.jar.CentralDirectoryEndRecord;
import org.springframework.boot.loader.jar.JarEntry;
import org.springframework.boot.loader.jar.JarEntryData;
import org.springframework.boot.loader.jar.JarEntryFilter;
import org.springframework.boot.loader.jar.JarURLStreamHandler;

public class JarFile
extends java.util.jar.JarFile
implements Iterable<JarEntryData> {
    private static final AsciiBytes META_INF = new AsciiBytes("META-INF/");
    private static final AsciiBytes MANIFEST_MF = new AsciiBytes("META-INF/MANIFEST.MF");
    private static final AsciiBytes SIGNATURE_FILE_EXTENSION = new AsciiBytes(".SF");
    private final RandomAccessDataFile rootFile;
    private RandomAccessData data;
    private final String name;
    private final long size;
    private boolean signed;
    private List<JarEntryData> entries;
    private SoftReference<Map<AsciiBytes, JarEntryData>> entriesByName;
    private JarEntryData manifestEntry;
    private SoftReference<Manifest> manifest;

    public JarFile(File file, JarEntryFilter ... filters) throws IOException {
        this(new RandomAccessDataFile(file), filters);
    }

    JarFile(RandomAccessDataFile file, JarEntryFilter ... filters) throws IOException {
        this(file, file.getFile().getPath(), file, filters);
    }

    private JarFile(RandomAccessDataFile rootFile, String name, RandomAccessData data, JarEntryFilter ... filters) throws IOException {
        super(rootFile.getFile());
        this.rootFile = rootFile;
        this.name = name;
        this.data = data;
        this.size = data.getSize();
        this.loadJarEntries(filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJarEntries(JarEntryFilter[] filters) throws IOException {
        CentralDirectoryEndRecord endRecord = new CentralDirectoryEndRecord(this.data);
        RandomAccessData centralDirectory = endRecord.getCentralDirectory(this.data);
        int numberOfRecords = endRecord.getNumberOfRecords();
        this.entries = new ArrayList<JarEntryData>(numberOfRecords);
        InputStream inputStream = centralDirectory.getInputStream(RandomAccessData.ResourceAccess.ONCE);
        try {
            JarEntryData entry = JarEntryData.fromInputStream(this, inputStream);
            while (entry != null) {
                this.addJarEntry(entry, filters);
                entry = JarEntryData.fromInputStream(this, inputStream);
            }
        }
        finally {
            inputStream.close();
        }
    }

    private void addJarEntry(JarEntryData entry, JarEntryFilter[] filters) {
        AsciiBytes name = entry.getName();
        for (JarEntryFilter filter : filters) {
            name = filter == null || name == null ? name : filter.apply(name, entry);
        }
        if (name != null) {
            entry.setName(name);
            this.entries.add(entry);
            if (name.startsWith(META_INF)) {
                this.processMetaInfEntry(name, entry);
            }
        }
    }

    private void processMetaInfEntry(AsciiBytes name, JarEntryData entry) {
        if (name.equals(MANIFEST_MF)) {
            this.manifestEntry = entry;
        }
        if (name.endsWith(SIGNATURE_FILE_EXTENSION)) {
            this.signed = true;
        }
    }

    protected final RandomAccessDataFile getRootJarFile() {
        return this.rootFile;
    }

    RandomAccessData getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        Manifest manifest;
        if (this.manifestEntry == null) {
            return null;
        }
        Manifest manifest2 = manifest = this.manifest == null ? null : this.manifest.get();
        if (manifest == null) {
            InputStream inputStream = this.manifestEntry.getInputStream();
            try {
                manifest = new Manifest(inputStream);
            }
            finally {
                inputStream.close();
            }
            this.manifest = new SoftReference<Manifest>(manifest);
        }
        return manifest;
    }

    @Override
    public Enumeration<java.util.jar.JarEntry> entries() {
        final Iterator<JarEntryData> iterator = this.iterator();
        return new Enumeration<java.util.jar.JarEntry>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public java.util.jar.JarEntry nextElement() {
                return ((JarEntryData)iterator.next()).asJarEntry();
            }
        };
    }

    @Override
    public Iterator<JarEntryData> iterator() {
        return this.entries.iterator();
    }

    @Override
    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    @Override
    public ZipEntry getEntry(String name) {
        JarEntryData jarEntryData = this.getJarEntryData(name);
        return jarEntryData == null ? null : jarEntryData.asJarEntry();
    }

    public JarEntryData getJarEntryData(String name) {
        JarEntryData entryData;
        Map<AsciiBytes, JarEntryData> entriesByName;
        if (name == null) {
            return null;
        }
        Map<AsciiBytes, JarEntryData> map = entriesByName = this.entriesByName == null ? null : this.entriesByName.get();
        if (entriesByName == null) {
            entriesByName = new HashMap<AsciiBytes, JarEntryData>();
            for (JarEntryData entry : this.entries) {
                entriesByName.put(entry.getName(), entry);
            }
            this.entriesByName = new SoftReference<Map<AsciiBytes, JarEntryData>>(entriesByName);
        }
        if ((entryData = entriesByName.get(new AsciiBytes(name))) == null && !name.endsWith("/")) {
            entryData = entriesByName.get(new AsciiBytes(name + "/"));
        }
        return entryData;
    }

    boolean isSigned() {
        return this.signed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupEntryCertificates() {
        try {
            JarInputStream inputStream = new JarInputStream(this.getData().getInputStream(RandomAccessData.ResourceAccess.ONCE));
            try {
                java.util.jar.JarEntry entry = inputStream.getNextJarEntry();
                while (entry != null) {
                    inputStream.closeEntry();
                    JarEntry jarEntry = this.getJarEntry(entry.getName());
                    if (jarEntry != null) {
                        jarEntry.setupCertificates(entry);
                    }
                    entry = inputStream.getNextJarEntry();
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry ze) throws IOException {
        return this.getContainedEntry(ze).getSource().getInputStream();
    }

    public synchronized JarFile getNestedJarFile(ZipEntry ze, JarEntryFilter ... filters) throws IOException {
        return this.getNestedJarFile(this.getContainedEntry(ze).getSource(), new JarEntryFilter[0]);
    }

    public synchronized JarFile getNestedJarFile(JarEntryData sourceEntry, JarEntryFilter ... filters) throws IOException {
        if (sourceEntry.isDirectory()) {
            return this.getNestedJarFileFromDirectoryEntry(sourceEntry, filters);
        }
        return this.getNestedJarFileFromFileEntry(sourceEntry, filters);
    }

    private JarFile getNestedJarFileFromDirectoryEntry(JarEntryData sourceEntry, JarEntryFilter ... filters) throws IOException {
        final AsciiBytes sourceName = sourceEntry.getName();
        JarEntryFilter[] filtersToUse = new JarEntryFilter[filters.length + 1];
        System.arraycopy(filters, 0, filtersToUse, 1, filters.length);
        filtersToUse[0] = new JarEntryFilter(){

            @Override
            public AsciiBytes apply(AsciiBytes name, JarEntryData entryData) {
                if (name.startsWith(sourceName) && !name.equals(sourceName)) {
                    return name.substring(sourceName.length());
                }
                return null;
            }
        };
        return new JarFile(this.rootFile, this.getName() + "!/" + sourceEntry.getName().substring(0, sourceName.length() - 1), this.data, filtersToUse);
    }

    private JarFile getNestedJarFileFromFileEntry(JarEntryData sourceEntry, JarEntryFilter ... filters) throws IOException {
        if (sourceEntry.getMethod() != 0) {
            throw new IllegalStateException("Unable to open nested compressed entry " + sourceEntry.getName());
        }
        return new JarFile(this.rootFile, this.getName() + "!/" + sourceEntry.getName(), sourceEntry.getData(), filters);
    }

    public synchronized JarFile getFilteredJarFile(JarEntryFilter ... filters) throws IOException {
        return new JarFile(this.rootFile, this.getName(), this.data, filters);
    }

    private JarEntry getContainedEntry(ZipEntry zipEntry) throws IOException {
        if (zipEntry instanceof JarEntry && ((JarEntry)zipEntry).getSource().getSource() == this) {
            return (JarEntry)zipEntry;
        }
        throw new IllegalArgumentException("ZipEntry must be contained in this file");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        return (int)this.size;
    }

    @Override
    public void close() throws IOException {
        this.rootFile.close();
    }

    public String toString() {
        return this.getName();
    }

    public URL getUrl() throws MalformedURLException {
        JarURLStreamHandler handler = new JarURLStreamHandler(this);
        return new URL("jar", "", -1, "file:" + this.getName() + "!/", handler);
    }
}

