/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.springframework.boot.loader.AsciiBytes;
import org.springframework.boot.loader.Launcher;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.archive.FilteredArchive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.boot.loader.util.SystemPropertyUtils;

public class PropertiesLauncher
extends Launcher {
    private Logger logger = Logger.getLogger(Launcher.class.getName());
    public static final String MAIN = "loader.main";
    public static final String PATH = "loader.path";
    public static final String HOME = "loader.home";
    public static final String CONFIG_NAME = "loader.config.name";
    public static final String CONFIG_LOCATION = "loader.config.location";
    public static final String SET_SYSTEM_PROPERTIES = "loader.system";
    private static final List<String> DEFAULT_PATHS = Arrays.asList("lib/");
    private final File home;
    private List<String> paths = new ArrayList<String>(DEFAULT_PATHS);
    private Properties properties = new Properties();

    public PropertiesLauncher() {
        try {
            this.home = this.getHomeDirectory();
            this.initializeProperties(this.home);
            this.initializePaths();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected File getHomeDirectory() {
        return new File(SystemPropertyUtils.resolvePlaceholders(System.getProperty(HOME, "${user.dir}")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeProperties(File home) throws Exception, IOException {
        String config = "classpath:" + SystemPropertyUtils.resolvePlaceholders(SystemPropertyUtils.getProperty(CONFIG_NAME, "application")) + ".properties";
        InputStream resource = this.getResource(config = SystemPropertyUtils.resolvePlaceholders(SystemPropertyUtils.getProperty(CONFIG_LOCATION, config)));
        if (resource != null) {
            this.logger.info("Found: " + config);
            try {
                this.properties.load(resource);
            }
            finally {
                resource.close();
            }
            for (Object key : Collections.list(this.properties.propertyNames())) {
                String text = this.properties.getProperty((String)key);
                String value = SystemPropertyUtils.resolvePlaceholders(this.properties, text);
                if (value == null) continue;
                this.properties.put(key, value);
            }
            if (SystemPropertyUtils.resolvePlaceholders("${loader.system:false}").equals("true")) {
                this.logger.info("Adding resolved properties to System properties");
                for (Object key : Collections.list(this.properties.propertyNames())) {
                    String value = this.properties.getProperty((String)key);
                    System.setProperty((String)key, value);
                }
            }
        } else {
            this.logger.info("Not found: " + config);
        }
    }

    private InputStream getResource(String config) throws Exception {
        if (config.startsWith("classpath:")) {
            return this.getClasspathResource(config.substring("classpath:".length()));
        }
        if (this.isUrl(config = this.stripFileUrlPrefix(config))) {
            return this.getURLResource(config);
        }
        return this.getFileResource(config);
    }

    private String stripFileUrlPrefix(String config) {
        if (config.startsWith("file:") && (config = config.substring("file:".length())).startsWith("//")) {
            config = config.substring(2);
        }
        return config;
    }

    private boolean isUrl(String config) {
        return config.contains("://");
    }

    private InputStream getClasspathResource(String config) {
        while (config.startsWith("/")) {
            config = config.substring(1);
        }
        config = "/" + config;
        this.logger.fine("Trying classpath: " + config);
        return this.getClass().getResourceAsStream(config);
    }

    private InputStream getFileResource(String config) throws Exception {
        File file = new File(config);
        this.logger.fine("Trying file: " + config);
        if (file.canRead()) {
            return new FileInputStream(file);
        }
        return null;
    }

    private InputStream getURLResource(String config) throws Exception {
        URL url = new URL(config);
        if (this.exists(url)) {
            URLConnection con = url.openConnection();
            try {
                return con.getInputStream();
            }
            catch (IOException ex) {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
                throw ex;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        try {
            connection.setUseCaches(connection.getClass().getSimpleName().startsWith("JNLP"));
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                httpConnection.setRequestMethod("HEAD");
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == 200) {
                    boolean bl = true;
                    return bl;
                }
                if (responseCode == 404) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = connection.getContentLength() >= 0;
            return bl;
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    private void initializePaths() throws IOException {
        String path = SystemPropertyUtils.getProperty(PATH);
        if (path == null) {
            path = this.properties.getProperty(PATH);
        }
        if (path != null) {
            this.paths = this.parsePathsProperty(SystemPropertyUtils.resolvePlaceholders(path));
        }
        this.logger.info("Nested archive paths: " + this.paths);
    }

    private List<String> parsePathsProperty(String commaSeparatedPaths) {
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : commaSeparatedPaths.split(",")) {
            if ((path = this.cleanupPath(path)).equals(".") || path.equals("")) continue;
            paths.add(path);
        }
        return paths;
    }

    @Override
    protected String getMainClass() throws Exception {
        String property = SystemPropertyUtils.getProperty(MAIN);
        if (property != null) {
            String mainClass = SystemPropertyUtils.resolvePlaceholders(property);
            this.logger.info("Main class from environment: " + mainClass);
            return mainClass;
        }
        if (this.properties.containsKey(MAIN)) {
            String mainClass = SystemPropertyUtils.resolvePlaceholders(this.properties.getProperty(MAIN));
            this.logger.info("Main class from properties: " + mainClass);
            return mainClass;
        }
        try {
            String mainClass = new ExplodedArchive(this.home).getMainClass();
            this.logger.info("Main class from home directory manifest: " + mainClass);
            return mainClass;
        }
        catch (IllegalStateException ex) {
            String mainClass = this.createArchive().getMainClass();
            this.logger.info("Main class from archive manifest: " + mainClass);
            return mainClass;
        }
    }

    @Override
    protected List<Archive> getClassPathArchives() throws Exception {
        ArrayList<Archive> lib = new ArrayList<Archive>();
        for (String path : this.paths) {
            for (Archive archive : this.getClassPathArchives(path)) {
                ArrayList<Archive> nested = new ArrayList<Archive>(archive.getNestedArchives(new ArchiveEntryFilter()));
                nested.add(0, archive);
                lib.addAll(nested);
            }
        }
        this.addParentClassLoaderEntries(lib);
        return lib;
    }

    private List<Archive> getClassPathArchives(String path) throws Exception {
        Archive nested;
        String root = this.cleanupPath(this.stripFileUrlPrefix(path));
        ArrayList<Archive> lib = new ArrayList<Archive>();
        File file = new File(root);
        if (!root.startsWith("/")) {
            file = new File(this.home, root);
        }
        if (file.isDirectory()) {
            this.logger.info("Adding classpath entries from " + file);
            ExplodedArchive archive = new ExplodedArchive(file);
            lib.add(archive);
        }
        if ((nested = this.getNestedArchive(root)) != null) {
            this.logger.info("Adding classpath entries from nested " + nested.getUrl() + root);
            lib.add(nested);
        }
        return lib;
    }

    private Archive getNestedArchive(String root) throws Exception {
        Archive parent = this.createArchive();
        if (root.startsWith("/") || parent.getUrl().equals(this.home.toURI().toURL())) {
            return null;
        }
        PrefixMatchingArchiveFilter filter = new PrefixMatchingArchiveFilter(root);
        if (parent.getNestedArchives(filter).isEmpty()) {
            return null;
        }
        return new FilteredArchive(parent, filter);
    }

    private Archive createArchive() throws Exception {
        String path;
        ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource == null ? null : codeSource.getLocation().toURI();
        String string = path = location == null ? null : location.getPath();
        if (path == null) {
            throw new IllegalStateException("Unable to determine code source archive");
        }
        File root = new File(path);
        if (!root.exists()) {
            throw new IllegalStateException("Unable to determine code source archive from " + root);
        }
        return root.isDirectory() ? new ExplodedArchive(root) : new JarFileArchive(root);
    }

    private void addParentClassLoaderEntries(List<Archive> lib) throws IOException, URISyntaxException {
        ClassLoader parentClassLoader = this.getClass().getClassLoader();
        if (parentClassLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)parentClassLoader;
            for (URL url : urlClassLoader.getURLs()) {
                if (url.toString().endsWith(".jar") || url.toString().endsWith(".zip")) {
                    lib.add(0, new JarFileArchive(new File(url.toURI())));
                    continue;
                }
                lib.add(0, new ExplodedArchive(new File(url.getFile())));
            }
        }
    }

    private String cleanupPath(String path) {
        if (!(path = path.trim()).endsWith("/")) {
            path = path + "/";
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        return path;
    }

    public static void main(String[] args) {
        new PropertiesLauncher().launch(args);
    }

    private static final class PrefixMatchingArchiveFilter
    implements Archive.EntryFilter {
        private final AsciiBytes prefix;
        private final ArchiveEntryFilter filter = new ArchiveEntryFilter();

        private PrefixMatchingArchiveFilter(String prefix) {
            this.prefix = new AsciiBytes(prefix);
        }

        @Override
        public boolean matches(Archive.Entry entry) {
            return entry.getName().startsWith(this.prefix) && this.filter.matches(entry);
        }
    }

    private static final class ArchiveEntryFilter
    implements Archive.EntryFilter {
        private static final AsciiBytes DOT_JAR = new AsciiBytes(".jar");
        private static final AsciiBytes DOT_ZIP = new AsciiBytes(".zip");

        private ArchiveEntryFilter() {
        }

        @Override
        public boolean matches(Archive.Entry entry) {
            return entry.isDirectory() || entry.getName().endsWith(DOT_JAR) || entry.getName().endsWith(DOT_ZIP);
        }
    }
}

