/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.springframework.boot.loader.LaunchedURLClassLoader;
import org.springframework.boot.loader.archive.Archive;

public abstract class Launcher {
    protected Logger logger = Logger.getLogger(Launcher.class.getName());
    private static final String RUNNER_CLASS = Launcher.class.getPackage().getName() + ".MainMethodRunner";

    protected void launch(String[] args) {
        try {
            ClassLoader classLoader = this.createClassLoader(this.getClassPathArchives());
            this.launch(args, this.getMainClass(), classLoader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    protected ClassLoader createClassLoader(List<Archive> archives) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>(archives.size());
        for (Archive archive : archives) {
            urls.add(archive.getUrl());
        }
        return this.createClassLoader(urls.toArray(new URL[urls.size()]));
    }

    protected ClassLoader createClassLoader(URL[] urls) throws Exception {
        return new LaunchedURLClassLoader(urls, this.getClass().getClassLoader());
    }

    protected void launch(String[] args, String mainClass, ClassLoader classLoader) throws Exception {
        Runnable runner = this.createMainMethodRunner(mainClass, args, classLoader);
        Thread runnerThread = new Thread(runner);
        runnerThread.setContextClassLoader(classLoader);
        runnerThread.setName(Thread.currentThread().getName());
        runnerThread.start();
    }

    protected Runnable createMainMethodRunner(String mainClass, String[] args, ClassLoader classLoader) throws Exception {
        Class<?> runnerClass = classLoader.loadClass(RUNNER_CLASS);
        Constructor<?> constructor = runnerClass.getConstructor(String.class, String[].class);
        return (Runnable)constructor.newInstance(mainClass, args);
    }

    protected abstract String getMainClass() throws Exception;

    protected abstract List<Archive> getClassPathArchives() throws Exception;
}

