/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.archive;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import org.springframework.boot.loader.archive.Archive;

public class FilteredArchive
extends Archive {
    private Archive parent;
    private Archive.EntryFilter filter;

    public FilteredArchive(Archive parent, Archive.EntryFilter filter) {
        this.parent = parent;
        this.filter = filter;
    }

    @Override
    public URL getUrl() throws MalformedURLException {
        return this.parent.getUrl();
    }

    @Override
    public String getMainClass() throws Exception {
        return this.parent.getMainClass();
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.parent.getManifest();
    }

    @Override
    public Collection<Archive.Entry> getEntries() {
        ArrayList<Archive.Entry> nested = new ArrayList<Archive.Entry>();
        for (Archive.Entry entry : this.parent.getEntries()) {
            if (!this.filter.matches(entry)) continue;
            nested.add(entry);
        }
        return Collections.unmodifiableList(nested);
    }

    @Override
    public List<Archive> getNestedArchives(final Archive.EntryFilter filter) throws IOException {
        return this.parent.getNestedArchives(new Archive.EntryFilter(){

            @Override
            public boolean matches(Archive.Entry entry) {
                return FilteredArchive.this.filter.matches(entry) && filter.matches(entry);
            }
        });
    }

    @Override
    public Archive getFilteredArchive(final Archive.EntryRenameFilter filter) throws IOException {
        return this.parent.getFilteredArchive(new Archive.EntryRenameFilter(){

            @Override
            public String apply(String entryName, Archive.Entry entry) {
                return FilteredArchive.this.filter.matches(entry) ? filter.apply(entryName, entry) : null;
            }
        });
    }
}

