/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.jar;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.boot.loader.data.RandomAccessData;
import org.springframework.boot.loader.jar.RandomAccessDataZipEntry;

public class RandomAccessDataZipInputStream
extends ZipInputStream {
    private RandomAccessData data;
    private TrackingInputStream trackingInputStream;

    public RandomAccessDataZipInputStream(RandomAccessData data) {
        this(data, new TrackingInputStream(data.getInputStream()));
    }

    private RandomAccessDataZipInputStream(RandomAccessData data, TrackingInputStream trackingInputStream) {
        super(trackingInputStream);
        this.data = data;
        this.trackingInputStream = trackingInputStream;
    }

    @Override
    public RandomAccessDataZipEntry getNextEntry() throws IOException {
        ZipEntry entry = super.getNextEntry();
        if (entry == null) {
            return null;
        }
        int start = this.getPosition();
        this.closeEntry();
        int end = this.getPosition();
        RandomAccessData entryData = this.data.getSubsection(start, end - start);
        return new RandomAccessDataZipEntry(entry, entryData);
    }

    private int getPosition() throws IOException {
        int pushback = ((PushbackInputStream)this.in).available();
        return this.trackingInputStream.getPosition() - pushback;
    }

    private static class TrackingInputStream
    extends FilterInputStream {
        private int position = 0;

        protected TrackingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            return this.moveOn(super.read(), true);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.moveOn(super.read(b), false);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.moveOn(super.read(b, off, len), false);
        }

        private int moveOn(int amount, boolean singleByteRead) {
            this.position += amount == -1 ? 0 : (singleByteRead ? 1 : amount);
            return amount;
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

